/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

public class CompositeTransferable
implements Transferable {
    private final Transferable t1;
    private final Transferable t2;

    public CompositeTransferable(Transferable transferable, Transferable transferable2) {
        this.t1 = transferable;
        this.t2 = transferable2;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        LinkedList<DataFlavor> linkedList = new LinkedList<DataFlavor>();
        linkedList.addAll(Arrays.asList(this.t1.getTransferDataFlavors()));
        linkedList.addAll(Arrays.asList(this.t2.getTransferDataFlavors()));
        return linkedList.toArray(new DataFlavor[linkedList.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.t1.isDataFlavorSupported(dataFlavor) || this.t2.isDataFlavorSupported(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.t1.isDataFlavorSupported(dataFlavor)) {
            return this.t1.getTransferData(dataFlavor);
        }
        if (this.t2.isDataFlavorSupported(dataFlavor)) {
            return this.t2.getTransferData(dataFlavor);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

