/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.dnd.MagnetTransferHandler;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import com.limegroup.gnutella.gui.dnd.SendFileTransferHandler;
import com.limegroup.gnutella.gui.dnd.TorrentFilesTransferHandler;
import com.limegroup.gnutella.gui.dnd.TorrentURITransferHandler;
import com.limegroup.gnutella.util.URIUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class DNDUtils {
    public static final List<LimeTransferHandler> DEFAULT_TRANSFER_HANDLERS = Collections.unmodifiableList(Arrays.asList(new MagnetTransferHandler(), new TorrentURITransferHandler(), new TorrentFilesTransferHandler(), new SendFileTransferHandler()));
    public static final LimeTransferHandler DEFAULT_TRANSFER_HANDLER = new MulticastTransferHandler(DEFAULT_TRANSFER_HANDLERS);

    public static URI[] getURIs(Transferable transferable) throws UnsupportedFlavorException, IOException {
        String string = (String)(DNDUtils.contains(transferable.getTransferDataFlavors(), FileTransferable.URIFlavor) ? transferable.getTransferData(FileTransferable.URIFlavor) : transferable.getTransferData(FileTransferable.URIFlavor16));
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator"));
        ArrayList<URI> arrayList = new ArrayList<URI>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0) continue;
            try {
                URI uRI = URIUtils.toURI(string2);
                arrayList.add(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                URIUtils.error(uRISyntaxException);
            }
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    public static boolean contains(DataFlavor[] dataFlavorArray, DataFlavor dataFlavor) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavor.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFileFlavors(DataFlavor[] dataFlavorArray) {
        if (dataFlavorArray == null) {
            return false;
        }
        return DNDUtils.contains(dataFlavorArray, DataFlavor.javaFileListFlavor) || DNDUtils.contains(dataFlavorArray, FileTransferable.URIFlavor) || DNDUtils.contains(dataFlavorArray, FileTransferable.URIFlavor16);
    }

    public static File[] getFiles(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (DNDUtils.contains(transferable.getTransferDataFlavors(), DataFlavor.javaFileListFlavor)) {
            return ((List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).toArray(new File[0]);
        }
        if (DNDUtils.contains(transferable.getTransferDataFlavors(), FileTransferable.URIFlavor) || DNDUtils.contains(transferable.getTransferDataFlavors(), FileTransferable.URIFlavor16)) {
            return DNDUtils.getFiles(DNDUtils.getURIs(transferable));
        }
        return new File[0];
    }

    public static File[] getFiles(URI[] uRIArray) {
        ArrayList<File> arrayList = new ArrayList<File>(uRIArray.length);
        for (URI uRI : uRIArray) {
            String string = uRI.getScheme();
            if (!uRI.isAbsolute() || string == null || !string.equalsIgnoreCase("file")) continue;
            String string2 = uRI.getPath();
            arrayList.add(new File(string2));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }
}

