/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.BasicDropTargetListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.UIResource;

public class LimeDropTarget
extends DropTarget
implements UIResource {
    private static final long serialVersionUID = 7798538644917817157L;
    private static DropTargetListener listener;
    private EventListenerList listenerList;

    private static DropTargetListener getDropTargetListener() {
        if (listener == null) {
            listener = new BasicDropTargetListener();
        }
        return listener;
    }

    public LimeDropTarget(JComponent jComponent) {
        this.setComponent(jComponent);
        try {
            super.addDropTargetListener(LimeDropTarget.getDropTargetListener());
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    @Override
    public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DropTargetListener.class, dropTargetListener);
    }

    @Override
    public void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(DropTargetListener.class, dropTargetListener);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        super.dragEnter(dropTargetDragEvent);
        if (this.listenerList != null) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DropTargetListener.class) continue;
                ((DropTargetListener)objectArray[i + 1]).dragEnter(dropTargetDragEvent);
            }
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        super.dragOver(dropTargetDragEvent);
        if (this.listenerList != null) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DropTargetListener.class) continue;
                ((DropTargetListener)objectArray[i + 1]).dragOver(dropTargetDragEvent);
            }
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        super.dragExit(dropTargetEvent);
        if (this.listenerList != null) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DropTargetListener.class) continue;
                ((DropTargetListener)objectArray[i + 1]).dragExit(dropTargetEvent);
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        super.drop(dropTargetDropEvent);
        if (this.listenerList != null) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DropTargetListener.class) continue;
                ((DropTargetListener)objectArray[i + 1]).drop(dropTargetDropEvent);
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        super.dropActionChanged(dropTargetDragEvent);
        if (this.listenerList != null) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DropTargetListener.class) continue;
                ((DropTargetListener)objectArray[i + 1]).dropActionChanged(dropTargetDragEvent);
            }
        }
    }
}

