/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.BasicDragGestureListener;
import com.limegroup.gnutella.gui.dnd.BasicTransferableCreator;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.TransferVisualizer;
import com.limegroup.gnutella.gui.dnd.TriggerableDragGestureRecognizer;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class LimeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 7753614134944789178L;
    private static TriggerableDragGestureRecognizer recognizer;
    private final int supportedActions;

    public LimeTransferHandler() {
        this.supportedActions = 0;
    }

    public LimeTransferHandler(int n) {
        this.supportedActions = n;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return false;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, DropInfo dropInfo) {
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        return new BasicTransferableCreator(jComponent).getTransferable();
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return this.supportedActions;
    }

    @Override
    public final Icon getVisualRepresentation(Transferable transferable) {
        throw new IllegalStateException("USE getImageRepresentation INSTEAD");
    }

    public Image getImageRepresentation(Transferable transferable) {
        return new TransferVisualizer(transferable).getImage();
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        return false;
    }

    public boolean importData(JComponent jComponent, Transferable transferable, DropInfo dropInfo) {
        return false;
    }

    @Override
    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        int n2 = this.getSourceActions(jComponent);
        int n3 = n2 & n;
        if (!(inputEvent instanceof MouseEvent)) {
            n3 = 0;
        }
        if (n3 != 0 && !GraphicsEnvironment.isHeadless()) {
            if (recognizer == null) {
                recognizer = new TriggerableDragGestureRecognizer(new BasicDragGestureListener());
            }
            recognizer.trigger(jComponent, (MouseEvent)inputEvent, n2, n3);
        } else {
            this.exportDone(jComponent, null, 0);
        }
    }
}

