/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;

public class MulticastTransferHandler
extends LimeTransferHandler {
    private static final long serialVersionUID = -400036212482333760L;
    private ArrayList<LimeTransferHandler> handlers = new ArrayList();
    private LimeTransferHandler lastTransferer;

    public MulticastTransferHandler() {
    }

    public MulticastTransferHandler(LimeTransferHandler limeTransferHandler) {
        this.handlers.add(limeTransferHandler);
    }

    public MulticastTransferHandler(LimeTransferHandler limeTransferHandler, Collection<LimeTransferHandler> collection) {
        this.handlers.add(limeTransferHandler);
        this.handlers.addAll(collection);
    }

    public MulticastTransferHandler(Collection<LimeTransferHandler> collection) {
        this.handlers.addAll(collection);
    }

    public void addTransferHandler(LimeTransferHandler limeTransferHandler) {
        this.handlers.add(limeTransferHandler);
    }

    public void removeTransferHandler(LimeTransferHandler limeTransferHandler) {
        this.handlers.remove(limeTransferHandler);
    }

    private LimeTransferHandler[] getHandlers() {
        return this.handlers.toArray(new LimeTransferHandler[this.handlers.size()]);
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, DropInfo dropInfo) {
        for (LimeTransferHandler limeTransferHandler : this.getHandlers()) {
            if (!limeTransferHandler.canImport(jComponent, dataFlavorArray, dropInfo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (LimeTransferHandler limeTransferHandler : this.getHandlers()) {
            if (!limeTransferHandler.canImport(jComponent, dataFlavorArray)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        for (LimeTransferHandler limeTransferHandler : this.getHandlers()) {
            Transferable transferable = limeTransferHandler.createTransferable(jComponent);
            if (transferable == null) continue;
            this.lastTransferer = limeTransferHandler;
            return transferable;
        }
        this.lastTransferer = null;
        return null;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable, DropInfo dropInfo) {
        for (LimeTransferHandler limeTransferHandler : this.getHandlers()) {
            if (!limeTransferHandler.importData(jComponent, transferable, dropInfo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        for (LimeTransferHandler limeTransferHandler : this.getHandlers()) {
            if (!limeTransferHandler.importData(jComponent, transferable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        int n = 0;
        for (LimeTransferHandler limeTransferHandler : this.getHandlers()) {
            n |= limeTransferHandler.getSourceActions(jComponent);
        }
        return n;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (this.lastTransferer != null) {
            this.lastTransferer.exportDone(jComponent, transferable, n);
            this.lastTransferer = null;
        }
    }
}

