/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.frostwire.gui.bittorrent.SendFileProgressDialog;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class SendFileTransferHandler
extends LimeTransferHandler {
    private static final long serialVersionUID = 6541019610960958928L;

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, DropInfo dropInfo) {
        return this.canImport(jComponent, dataFlavorArray);
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return DNDUtils.containsFileFlavors(dataFlavorArray);
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable, DropInfo dropInfo) {
        return this.importData(jComponent, transferable);
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            return false;
        }
        try {
            File[] fileArray = DNDUtils.getFiles(transferable);
            if (fileArray.length == 1) {
                return SendFileTransferHandler.handleFiles(fileArray);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean handleFiles(File[] fileArray) {
        String string = fileArray[0].isFile() ? I18n.tr("file") : I18n.tr("folder");
        int n = JOptionPane.showConfirmDialog(GUIMediator.getAppFrame(), I18n.tr("Do you want to send this {0} to a friend?", string) + "\n\n\"" + fileArray[0].getName() + "\"", I18n.tr("Send files with FrostWire"), 0, 3);
        if (n == 0) {
            new SendFileProgressDialog(GUIMediator.getAppFrame(), fileArray[0]).setVisible(true);
            GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
            return true;
        }
        return false;
    }
}

