/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;

public class TorrentFilesTransferHandler
extends LimeTransferHandler {
    private static final long serialVersionUID = 5478003116391589602L;

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, DropInfo dropInfo) {
        return this.canImport(jComponent, dataFlavorArray);
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return DNDUtils.contains(dataFlavorArray, DataFlavor.javaFileListFlavor) || DNDUtils.contains(dataFlavorArray, FileTransferable.URIFlavor);
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable, DropInfo dropInfo) {
        return this.importData(jComponent, transferable);
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            return false;
        }
        try {
            File[] fileArray = DNDUtils.getFiles(transferable);
            if (this.areAllTorrentFiles(fileArray)) {
                if (fileArray.length == 1) {
                    GUIMediator.instance().openTorrentFile(fileArray[0], true);
                } else {
                    for (File file : fileArray) {
                        GUIMediator.instance().openTorrentFile(file, false);
                    }
                }
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    boolean areAllTorrentFiles(File[] fileArray) {
        for (File file : fileArray) {
            if (file.isFile() && file.getName().toLowerCase().endsWith(".torrent")) continue;
            return false;
        }
        return true;
    }
}

