/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.BasicDropTargetListener;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

public class TransferHandlerDropTargetListener
implements DropTargetListener {
    private final LimeTransferHandler handler;

    public TransferHandlerDropTargetListener(LimeTransferHandler limeTransferHandler) {
        if (limeTransferHandler == null) {
            throw new NullPointerException("handler must not be null");
        }
        this.handler = limeTransferHandler;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        BasicDropTargetListener.DropDragInfo dropDragInfo;
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (this.handler.canImport(null, dataFlavorArray, dropDragInfo = new BasicDropTargetListener.DropDragInfo(dropTargetDragEvent)) && this.actionSupported(dropDragInfo.action)) {
            dropTargetDragEvent.acceptDrag(dropDragInfo.action);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        BasicDropTargetListener.DropDragInfo dropDragInfo;
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (this.handler.canImport(null, dataFlavorArray, dropDragInfo = new BasicDropTargetListener.DropDragInfo(dropTargetDragEvent)) && this.actionSupported(dropDragInfo.action)) {
            dropTargetDragEvent.acceptDrag(dropDragInfo.action);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        BasicDropTargetListener.DropDropInfo dropDropInfo;
        DataFlavor[] dataFlavorArray = dropTargetDropEvent.getCurrentDataFlavors();
        if (this.handler.canImport(null, dataFlavorArray, dropDropInfo = new BasicDropTargetListener.DropDropInfo(dropTargetDropEvent)) && this.actionSupported(dropDropInfo.action)) {
            dropTargetDropEvent.acceptDrop(dropDropInfo.action);
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                dropTargetDropEvent.dropComplete(this.handler.importData(null, transferable, dropDropInfo));
            }
            catch (RuntimeException runtimeException) {
                dropTargetDropEvent.dropComplete(false);
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        BasicDropTargetListener.DropDragInfo dropDragInfo;
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (this.handler.canImport(null, dataFlavorArray, dropDragInfo = new BasicDropTargetListener.DropDragInfo(dropTargetDragEvent)) && this.actionSupported(dropDragInfo.action)) {
            dropTargetDragEvent.acceptDrag(dropDragInfo.action);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private boolean actionSupported(int n) {
        return (n & 0x40000003) != 0;
    }
}

