/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.bittorrent.TorrentUtil;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.iTunesImportSettings;
import com.limegroup.gnutella.settings.iTunesSettings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.IOUtils;
import org.limewire.util.OSUtils;

public final class iTunesMediator {
    private static final Log LOG = LogFactory.getLog(iTunesMediator.class);
    private static final String JS_IMPORT_SCRIPT_NAME = "itunes_import.js";
    private static final String JS_REMOVE_PLAYLIST_SCRIPT_NAME = "itunes_remove_playlist.js";
    private static iTunesMediator INSTANCE;
    private final ExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("iTunesAdderThread");

    public static synchronized iTunesMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new iTunesMediator();
        }
        return INSTANCE;
    }

    private iTunesMediator() {
        if (OSUtils.isWindows()) {
            iTunesMediator.createiTunesJavaScript(JS_IMPORT_SCRIPT_NAME);
            iTunesMediator.createiTunesJavaScript(JS_REMOVE_PLAYLIST_SCRIPT_NAME);
        }
    }

    private void addSongsITunes(String string, File file) {
        File[] fileArray;
        try {
            file = FileUtils.getCanonicalFile(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!file.exists()) {
            LOG.warn("File: '" + file + "' does not exist");
            return;
        }
        if (file.isDirectory()) {
            fileArray = FileUtils.getFilesRecursive(file, iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.getValue());
        } else if (file.isFile() && iTunesMediator.isSupported(FileUtils.getFileExtension(file))) {
            fileArray = new File[]{file};
        } else {
            return;
        }
        if (fileArray.length == 0) {
            return;
        }
        this.addSongsiTunes(string, fileArray);
    }

    public void addSongsiTunes(String string, File[] fileArray) {
        Set<File> set = TorrentUtil.getIncompleteFiles();
        set.addAll(TorrentUtil.getSkipedFiles());
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        for (File file : fileArray) {
            if (set.contains(file) || !file.exists() || !file.isFile() || !iTunesMediator.isSupported(FileUtils.getFileExtension(file))) continue;
            arrayList.add(file);
        }
        fileArray = arrayList.toArray(new File[0]);
        if (fileArray.length == 0) {
            return;
        }
        if (OSUtils.isMacOSX()) {
            this.QUEUE.execute(new ExecOSAScriptCommand(string, fileArray));
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Will add '" + fileArray.length + " files" + "' to Playlist");
            }
            this.QUEUE.execute(new ExecWSHScriptCommand(string, fileArray));
        }
    }

    private static boolean isSupported(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = iTunesSettings.ITUNES_SUPPORTED_FILE_TYPES.getValue();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private static String[] createOSAScriptCommand(String string, File[] fileArray) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("osascript");
        arrayList.add("-e");
        arrayList.add("tell application \"Finder\"");
        for (n = 0; n < fileArray.length; ++n) {
            File file = fileArray[n];
            String string2 = file.getAbsolutePath();
            arrayList.add("-e");
            arrayList.add("set hfsFile" + n + " to (POSIX file \"" + string2 + "\")");
        }
        arrayList.add("-e");
        arrayList.add("set thePlaylist to \"" + string + "\"");
        arrayList.add("-e");
        arrayList.add("tell application \"iTunes\"");
        arrayList.add("-e");
        arrayList.add("launch");
        arrayList.add("-e");
        arrayList.add("if not (exists playlist thePlaylist) then");
        arrayList.add("-e");
        arrayList.add("set thisPlaylist to make new playlist");
        arrayList.add("-e");
        arrayList.add("set name of thisPlaylist to thePlaylist");
        arrayList.add("-e");
        arrayList.add("end if");
        for (n = 0; n < fileArray.length; ++n) {
            arrayList.add("-e");
            arrayList.add("add hfsFile" + n + " to playlist thePlaylist");
        }
        arrayList.add("-e");
        arrayList.add("end tell");
        arrayList.add("-e");
        arrayList.add("end tell");
        return arrayList.toArray(new String[0]);
    }

    private static String[] createWSHScriptCommand(String string, File[] fileArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("wscript");
        arrayList.add("//B");
        arrayList.add("//NoLogo");
        arrayList.add(new File(CommonUtils.getUserSettingsDir(), JS_IMPORT_SCRIPT_NAME).getAbsolutePath());
        arrayList.add(string);
        for (File file : fileArray) {
            arrayList.add(file.getAbsolutePath());
        }
        return arrayList.toArray(new String[0]);
    }

    public void scanForSongs(File file) {
        this.scanForSongs(iTunesSettings.ITUNES_PLAYLIST.getValue(), file);
    }

    public void scanForSongs(String string, File file) {
        iTunesImportSettings.IMPORT_FILES.add(file);
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            this.addSongsITunes(string, file);
        } else if (OSUtils.isUbuntu()) {
            // empty if block
        }
    }

    public boolean isScanned(File file) {
        return iTunesImportSettings.IMPORT_FILES.contains(file);
    }

    public void removeFromScanned(File file) {
        iTunesImportSettings.IMPORT_FILES.remove(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createiTunesJavaScript(String string) {
        FileOutputStream fileOutputStream;
        BufferedInputStream bufferedInputStream;
        block5: {
            File file = new File(CommonUtils.getUserSettingsDir(), string);
            if (file.exists()) {
                return;
            }
            URL uRL = ResourceManager.getURLResource(string);
            bufferedInputStream = null;
            fileOutputStream = null;
            try {
                if (uRL == null) break block5;
                bufferedInputStream = new BufferedInputStream(uRL.openStream());
                fileOutputStream = new FileOutputStream(file);
                IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)fileOutputStream);
            }
            catch (IOException iOException) {
                try {
                    LOG.error("Error creating iTunes javascript", iOException);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bufferedInputStream);
                    IOUtils.closeQuietly(fileOutputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly(bufferedInputStream);
                IOUtils.closeQuietly(fileOutputStream);
            }
        }
        IOUtils.closeQuietly(bufferedInputStream);
        IOUtils.closeQuietly(fileOutputStream);
    }

    public void deleteFrostWirePlaylist() {
        String string = iTunesSettings.ITUNES_PLAYLIST.getValue();
        try {
            if (OSUtils.isMacOSX()) {
                String[] stringArray = new String[]{"osascript", "-e", "tell application \"iTunes\"", "-e", "delete playlist \"" + string + "\"", "-e", "end tell"};
                Runtime.getRuntime().exec(stringArray);
            } else if (OSUtils.isWindows()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("wscript");
                arrayList.add("//B");
                arrayList.add("//NoLogo");
                arrayList.add(new File(CommonUtils.getUserSettingsDir(), JS_REMOVE_PLAYLIST_SCRIPT_NAME).getAbsolutePath());
                arrayList.add(string);
                Runtime.getRuntime().exec(arrayList.toArray(new String[0]));
            }
        }
        catch (IOException iOException) {
            LOG.error("Error executing itunes command", iOException);
        }
    }

    public void resetFrostWirePlaylist() {
        this.deleteFrostWirePlaylist();
        this.QUEUE.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iTunesMediator.instance().scanForSongs(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue());
            }
        });
    }

    private class ExecWSHScriptCommand
    implements Runnable {
        private final String playlist;
        private final File[] files;

        public ExecWSHScriptCommand(String string, File[] fileArray) {
            this.playlist = string;
            this.files = fileArray;
        }

        @Override
        public void run() {
            try {
                Runtime.getRuntime().exec(iTunesMediator.createWSHScriptCommand(this.playlist, this.files));
            }
            catch (IOException iOException) {
                LOG.debug(iOException);
            }
        }
    }

    private class ExecOSAScriptCommand
    implements Runnable {
        private final String playlist;
        private final File[] files;

        public ExecOSAScriptCommand(String string, File[] fileArray) {
            this.playlist = string;
            this.files = fileArray;
        }

        @Override
        public void run() {
            try {
                Runtime.getRuntime().exec(iTunesMediator.createOSAScriptCommand(this.playlist, this.files));
            }
            catch (IOException iOException) {
                LOG.debug(iOException);
            }
        }
    }
}

