/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.frostwire.AzureusStarter;
import com.frostwire.gui.bittorrent.TorrentSaveFolderComponent;
import com.frostwire.gui.bittorrent.TorrentSeedingSettingComponent;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.CommonUtils;
import org.limewire.util.StringUtils;

class BitTorrentSettingsWindow
extends SetupWindow {
    private static final long serialVersionUID = 4918724013794478084L;
    private static final String LEARN_MORE_URL = "http://www.frostwire.com/faq#fil7";
    private TorrentSaveFolderComponent _torrentSaveFolderComponent;
    private TorrentSeedingSettingComponent _torrentSeedingSettingComponent;

    BitTorrentSettingsWindow(SetupManager setupManager) {
        super(setupManager, I18nMarker.marktr("BitTorrent Sharing Settings"), BitTorrentSettingsWindow.describeText(), LEARN_MORE_URL);
    }

    private static String describeText() {
        return I18nMarker.marktr("Choose a folder where files downloaded from the BitTorrent network should be saved to.\nPlease select if you want to \"Seed\" or to not \"Seed\" finished downloads. The link below has more information about \"Seeding\".");
    }

    @Override
    protected void createWindow() {
        super.createWindow();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._torrentSaveFolderComponent = new TorrentSaveFolderComponent(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        jPanel.add((Component)this._torrentSaveFolderComponent, gridBagConstraints);
        this._torrentSeedingSettingComponent = new TorrentSeedingSettingComponent(false, true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        jPanel.add((Component)this._torrentSeedingSettingComponent, gridBagConstraints);
        this.setSetupComponent(jPanel);
    }

    @Override
    public void applySettings(boolean bl) throws ApplySettingsException {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        this.applyTorrentDataSaveFolderSettings(arrayList);
        this.applyTorrentSeedingSeetings(arrayList);
        if (!arrayList.isEmpty()) {
            throw new ApplySettingsException(StringUtils.explode(arrayList, "\n\n"));
        }
    }

    private void applyTorrentSeedingSeetings(List<String> list) {
        if (!this._torrentSeedingSettingComponent.hasOneBeenSelected()) {
            list.add(I18n.tr("<html><p>You forgot to select your finished downloads \"Seeding\" setting.</p>\n<p></p><p align=\"right\"><a href=\"{0}\">What is \"Seeding\"?</a></p></html>", LEARN_MORE_URL));
            return;
        }
        SharingSettings.SEED_FINISHED_TORRENTS.setValue(this._torrentSeedingSettingComponent.wantsSeeding());
    }

    private void applyTorrentDataSaveFolderSettings(List<String> list) {
        File file = new File(this._torrentSaveFolderComponent.getTorrentSaveFolderPath());
        if (file.exists() && file.isDirectory() && file.canWrite()) {
            SharingSettings.TORRENT_DATA_DIR_SETTING.setValue(file);
        } else if (!file.mkdirs()) {
            list.add(I18n.tr("FrostWire could not create the Torrent Data Folder {0}", file));
        } else {
            SharingSettings.TORRENT_DATA_DIR_SETTING.setValue(file);
        }
        this.setupInitialLibraryFolders();
    }

    private void setupInitialLibraryFolders() {
        LibrarySettings.DIRECTORIES_TO_INCLUDE.add(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue());
        for (File file : FrostWireUtils.getFrostWire4SaveDirectories()) {
            LibrarySettings.DIRECTORIES_TO_INCLUDE.add(file);
            LibrarySettings.DIRECTORIES_TO_INCLUDE_FROM_FROSTWIRE4.add(file);
        }
        if (LibrarySettings.USER_MUSIC_FOLDER.getValue().exists()) {
            LibrarySettings.DIRECTORIES_TO_INCLUDE.add(LibrarySettings.USER_MUSIC_FOLDER.getValue());
        }
        LibrarySettings.DIRECTORIES_TO_INCLUDE.add(LibrarySettings.LIBRARY_FROM_DEVICE_DATA_DIR_SETTING.getValue());
        File file = new File(CommonUtils.getUserSettingsDir() + File.separator + "azureus" + File.separator);
        if (!file.exists()) {
            System.setProperty("azureus.config.path", file.getAbsolutePath());
            System.setProperty("azureus.install.path", file.getAbsolutePath());
            AzureusStarter.revertToDefaultConfiguration();
        }
    }
}

