/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.frostwire.gui.ChatMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.WindowsUtils;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.MacOSXUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.OSUtils;

final class MiscWindow
extends SetupWindow {
    private static final long serialVersionUID = 7123281955288276885L;
    private JTextField _ircNickField;
    private JCheckBox _startup;

    MiscWindow(SetupManager setupManager) {
        super(setupManager, I18nMarker.marktr("Miscellaneous Settings"), I18nMarker.marktr("Below, are several options that affect the functionality of FrostWire."));
    }

    @Override
    protected void createWindow() {
        Object object;
        JComponent jComponent;
        Serializable serializable;
        super.createWindow();
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            serializable = new GridBagConstraints();
            jComponent = new JPanel(new GridBagLayout());
            jComponent.putClientProperty("CLIENT_PROPERTY_DARK_DARK_NOISE", true);
            jComponent.setBorder(ThemeMediator.CURRENT_THEME.getCustomUI().createTitledBorder(I18n.tr("System Startup")));
            this._startup = new JCheckBox(I18n.tr("Start Automatically"));
            this._startup.setSelected(StartupSettings.RUN_ON_STARTUP.getValue());
            System.out.println("********START UP AUTOMAGICALLY?: ******" + StartupSettings.RUN_ON_STARTUP.getValue());
            object = new JLabel("<html>" + I18n.tr("Would you like FrostWire to start when you log into your computer? This will cause FrostWire to start faster when you use it later.") + "</html>");
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
            ((JComponent)object).setForeground(Color.black);
            ((JComponent)object).setFont(((Component)object).getFont().deriveFont(0));
            ((GridBagConstraints)serializable).anchor = 18;
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).weightx = 1.0;
            jComponent.add((Component)object, serializable);
            jComponent.add((Component)this._startup, serializable);
            ((GridBagConstraints)serializable).insets = new Insets(0, 0, 10, 0);
            jPanel.add((Component)jComponent, serializable);
        }
        serializable = new JPanel(new GridLayout(2, 0));
        ((JComponent)serializable).putClientProperty("CLIENT_PROPERTY_DARK_DARK_NOISE", true);
        ((JComponent)serializable).setBorder(ThemeMediator.CURRENT_THEME.getCustomUI().createTitledBorder(I18n.tr("Chat Community")));
        jComponent = new JLabel("<html>" + I18n.tr("FrostWire's Community Chat Tab requires you to have a nickname to communicate with others in the chatrooms.") + "</html>");
        jComponent.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
        jComponent.setForeground(Color.black);
        jComponent.setFont(jComponent.getFont().deriveFont(0));
        this._ircNickField = new SizedTextField(new Dimension(100, 20));
        object = new LabeledComponent(I18n.tr("Type your chat nickname here (any name):"), this._ircNickField, 130, 10);
        ((LabeledComponent)object).getBoxPanelComponent().setBorder(new EmptyBorder(0, 10, 5, 5));
        ((Container)serializable).add(jComponent);
        ((Container)serializable).add(((LabeledComponent)object).getComponent());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = -1;
        jPanel.add((Component)serializable, gridBagConstraints);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).fill = 3;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        jPanel.add((Component)new JPanel(), serializable);
        this.setSetupComponent(jPanel);
    }

    @Override
    public void applySettings(boolean bl) {
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            boolean bl2 = this._startup.isSelected();
            if (OSUtils.isMacOSX()) {
                MacOSXUtils.setLoginStatus(bl2);
            } else if (WindowsUtils.isLoginStatusAvailable()) {
                WindowsUtils.setLoginStatus(bl2);
            }
            StartupSettings.RUN_ON_STARTUP.setValue(bl2);
        }
        ChatSettings.CHAT_IRC_NICK.setValue(this._ircNickField.getText());
        ChatMediator.instance().reloadConfiguration();
    }
}

