/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FramedDialog;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.Line;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.AssociationsWindow;
import com.limegroup.gnutella.gui.init.BitTorrentSettingsWindow;
import com.limegroup.gnutella.gui.init.IntentWindow;
import com.limegroup.gnutella.gui.init.LanguagePanel;
import com.limegroup.gnutella.gui.init.MiscWindow;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.init.SetupWindowHolder;
import com.limegroup.gnutella.gui.init.WelcomeWindow;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.InstallSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.limewire.i18n.I18nMarker;
import org.limewire.setting.FileSetting;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.OSUtils;

public class SetupManager {
    private FramedDialog dialogFrame;
    private SetupWindowHolder _setupWindowHolder;
    private SetupWindow _currentWindow;
    private Dimension holderPreferredSize;
    public static final int ACTION_PREVIOUS = 1;
    public static final int ACTION_NEXT = 2;
    public static final int ACTION_FINISH = 4;
    public static final int ACTION_CANCEL = 8;
    private PreviousAction previousAction = new PreviousAction();
    private NextAction nextAction = new NextAction();
    private FinishAction finishAction = new FinishAction();
    private CancelAction cancelAction = new CancelAction();
    private LanguageAwareAction[] actions = new LanguageAwareAction[]{this.previousAction, this.nextAction, this.finishAction, this.cancelAction};
    private List<SetupWindow> windows;

    private boolean shouldShowAssociationsWindow() {
        if (InstallSettings.ASSOCIATION_OPTION.getValue() == 2) {
            return false;
        }
        return !GUIMediator.getAssociationManager().checkAndGrab(false);
    }

    private SaveStatus shouldShowSaveDirectoryWindow() {
        if (!InstallSettings.SAVE_DIRECTORY.getValue()) {
            return SaveStatus.NEEDS;
        }
        FileSetting fileSetting = SharingSettings.DIRECTORY_FOR_SAVING_FILES;
        if (fileSetting.isDefault()) {
            // empty if block
        }
        if (!InstallSettings.LAST_FROSTWIRE_VERSION_WIZARD_INVOKED.getValue().equals(FrostWireUtils.getFrostWireVersion())) {
            this.performAdditionalResets();
            return SaveStatus.NEEDS;
        }
        return SaveStatus.NO;
    }

    private void performAdditionalResets() {
        ThemeMediator.changeTheme(ThemeMediator.DEFAULT_THEME);
    }

    public void createIfNeeded() {
        IntentWindow intentWindow;
        this._setupWindowHolder = new SetupWindowHolder();
        this.windows = new LinkedList<SetupWindow>();
        SaveStatus saveStatus = this.shouldShowSaveDirectoryWindow();
        if (saveStatus != SaveStatus.NO) {
            this.windows.add(new BitTorrentSettingsWindow(this));
        }
        if (!InstallSettings.SPEED.getValue() || !InstallSettings.START_STARTUP.getValue() && GUIUtils.shouldShowStartOnStartupWindow()) {
            this.windows.add(new MiscWindow(this));
        }
        if (this.shouldShowAssociationsWindow()) {
            this.windows.add(new AssociationsWindow(this));
        }
        if (!(intentWindow = new IntentWindow(this)).isConfirmedWillNot()) {
            this.windows.add(intentWindow);
        }
        if (this.windows.size() == 0) {
            return;
        }
        boolean bl = ApplicationSettings.INSTALLED.getValue();
        this.windows.add(0, new WelcomeWindow(this, bl));
        this.holderPreferredSize = new Dimension(0, 0);
        SetupWindow setupWindow = null;
        for (SetupWindow setupWindow2 : this.windows) {
            this._setupWindowHolder.add(setupWindow2);
            if (setupWindow == null) {
                setupWindow2.setPrevious(setupWindow2);
            } else {
                setupWindow2.setPrevious(setupWindow);
            }
            if (setupWindow != null) {
                setupWindow.setNext(setupWindow2);
            }
            setupWindow = setupWindow2;
            Dimension dimension = setupWindow2.calculatePreferredSize();
            if (dimension.width > this.holderPreferredSize.width) {
                this.holderPreferredSize.width = dimension.width;
            }
            if (dimension.height <= this.holderPreferredSize.height) continue;
            this.holderPreferredSize.height = dimension.height;
        }
        this.holderPreferredSize.width += 20;
        this.holderPreferredSize.height += 20;
        if (this.holderPreferredSize.width > 900) {
            this.holderPreferredSize.width = 900;
        }
        if (this.holderPreferredSize.height > 750) {
            this.holderPreferredSize.height = 750;
        }
        assert (setupWindow != null);
        setupWindow.setNext(setupWindow);
        ThemeMediator.resetFontSizes();
        this.createDialog(this.windows.get(0));
    }

    private void createDialog(SetupWindow setupWindow) {
        this.dialogFrame = new FramedDialog();
        this.dialogFrame.setTitle("FrostWire Setup");
        this.dialogFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SetupManager.this.cancelSetup();
            }
        });
        JDialog jDialog = this.dialogFrame.getDialog();
        jDialog.setModal(true);
        jDialog.setTitle(I18n.tr("FrostWire Setup Wizard"));
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SetupManager.this.cancelSetup();
            }
        });
        Container container = jDialog.getContentPane();
        ((JComponent)container).putClientProperty("CLIENT_PROPERTY_LIGHT_NOISE", true);
        GUIUtils.addHideAction((JComponent)container);
        BoxLayout boxLayout = new BoxLayout(container, 1);
        container.setLayout(boxLayout);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        BoxLayout boxLayout2 = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout2);
        Dimension dimension = new Dimension(700, 433);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        jDialog.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        if (OSUtils.isGoodWindows()) {
            this._setupWindowHolder.setPreferredSize(this.holderPreferredSize);
        }
        jPanel.add(this._setupWindowHolder);
        jPanel.add(Box.createVerticalStrut(17));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        ButtonRow buttonRow = new ButtonRow(this.actions, 0, 12);
        LanguagePanel languagePanel = new LanguagePanel(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetupManager.this.updateLanguage();
            }
        });
        jPanel2.add(languagePanel);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(buttonRow);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        jPanel.add(new Line());
        jPanel.add(jPanel2);
        this.show(setupWindow);
        container.add(jPanel);
        if (!OSUtils.isGoodWindows()) {
            ((JComponent)container).setPreferredSize(new Dimension(700, 433));
        }
        jDialog.pack();
        SplashWindow.instance().setVisible(false);
        this.dialogFrame.showDialog();
        SplashWindow.instance().setVisible(true);
    }

    public void enableActions(int n) {
        this.previousAction.setEnabled((n & 1) != 0);
        this.nextAction.setEnabled((n & 2) != 0);
        this.finishAction.setEnabled((n & 4) != 0);
        this.cancelAction.setEnabled((n & 8) != 0);
    }

    public int getEnabledActions() {
        int n = 0;
        if (this.previousAction.isEnabled()) {
            n |= 1;
        }
        if (this.nextAction.isEnabled()) {
            n |= 2;
        }
        if (this.finishAction.isEnabled()) {
            n |= 4;
        }
        if (this.cancelAction.isEnabled()) {
            n |= 8;
        }
        return n;
    }

    public Component getOwnerComponent() {
        return this.dialogFrame;
    }

    public void next() {
        block2: {
            SetupWindow setupWindow = this._currentWindow.getNext();
            try {
                this._currentWindow.applySettings(true);
                this.show(setupWindow);
            }
            catch (ApplySettingsException applySettingsException) {
                if (applySettingsException.getMessage() == null || applySettingsException.getMessage().length() <= 0) break block2;
                GUIMediator.showError(applySettingsException.getMessage());
            }
        }
    }

    public void previous() {
        SetupWindow setupWindow = this._currentWindow.getPrevious();
        try {
            this._currentWindow.applySettings(false);
            this.show(setupWindow);
        }
        catch (ApplySettingsException applySettingsException) {
            // empty catch block
        }
    }

    public void cancelSetup() {
        this.dialogFrame.getDialog().dispose();
        System.exit(0);
    }

    public void finishSetup() {
        if (this._currentWindow != null) {
            try {
                this._currentWindow.applySettings(true);
            }
            catch (ApplySettingsException applySettingsException) {
                if (applySettingsException.getMessage() != null && applySettingsException.getMessage().length() > 0) {
                    GUIMediator.showError(applySettingsException.getMessage());
                }
                return;
            }
        }
        this.dialogFrame.getDialog().dispose();
        ApplicationSettings.INSTALLED.setValue(true);
        InstallSettings.SAVE_DIRECTORY.setValue(true);
        InstallSettings.SPEED.setValue(true);
        InstallSettings.SCAN_FILES.setValue(true);
        InstallSettings.LANGUAGE_CHOICE.setValue(true);
        InstallSettings.FILTER_OPTION.setValue(true);
        InstallSettings.EXTENSION_OPTION.setValue(true);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            InstallSettings.START_STARTUP.setValue(true);
        }
        if (OSUtils.isWindows()) {
            InstallSettings.FIREWALL_WARNING.setValue(true);
        }
        InstallSettings.ASSOCIATION_OPTION.setValue(2);
        InstallSettings.LAST_FROSTWIRE_VERSION_WIZARD_INVOKED.setValue(FrostWireUtils.getFrostWireVersion());
        Future<Void> future = BackgroundExecutorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                SettingsGroupManager.instance().save();
                return null;
            }
        });
        if (this._currentWindow instanceof IntentWindow) {
            IntentWindow intentWindow = (IntentWindow)this._currentWindow;
            if (!intentWindow.isConfirmedWillNot()) {
                GUIMediator.showWarning("FrostWire is not distributed to people who intend to use it for the purposes of copyright infringement.\n\nThank you for your interest; however, you cannot continue to use FrostWire at this time.");
                try {
                    future.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(1);
            }
            intentWindow.applySettings(true);
        }
        this.dialogFrame.getDialog().dispose();
    }

    public void updateLanguage() {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].updateLanguage();
        }
        try {
            this._currentWindow.applySettings(false);
        }
        catch (ApplySettingsException applySettingsException) {
            // empty catch block
        }
        this._currentWindow.handleWindowOpeningEvent();
    }

    private void show(SetupWindow setupWindow) {
        setupWindow.handleWindowOpeningEvent();
        this._setupWindowHolder.show(setupWindow.getKey());
        this._currentWindow = setupWindow;
    }

    void add(SetupWindow setupWindow) {
        this._setupWindowHolder.add((Component)setupWindow, setupWindow.getKey());
    }

    private class FinishAction
    extends LanguageAwareAction {
        private static final long serialVersionUID = 7243495030424309213L;

        public FinishAction() {
            super(I18nMarker.marktr("Finish"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SetupManager.this.finishSetup();
        }
    }

    private class PreviousAction
    extends LanguageAwareAction {
        private static final long serialVersionUID = -6355909946850317926L;

        public PreviousAction() {
            super(I18nMarker.marktr("<< Back"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SetupManager.this.previous();
        }
    }

    private class NextAction
    extends LanguageAwareAction {
        private static final long serialVersionUID = 8396346766881170337L;

        public NextAction() {
            super(I18nMarker.marktr("Next >>"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SetupManager.this.next();
        }
    }

    private class CancelAction
    extends LanguageAwareAction {
        private static final long serialVersionUID = -337264221787811634L;

        public CancelAction() {
            super(I18nMarker.marktr("Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SetupManager.this.cancelSetup();
        }
    }

    private abstract class LanguageAwareAction
    extends AbstractAction {
        private static final long serialVersionUID = -9116039417985018834L;
        private final String nameKey;

        public LanguageAwareAction(String string) {
            super(I18n.tr(string));
            this.nameKey = string;
        }

        public void updateLanguage() {
            this.putValue("Name", I18n.tr(this.nameKey));
        }
    }

    private static enum SaveStatus {
        NO,
        NEEDS;

    }
}

