/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class WelcomeWindow
extends SetupWindow {
    private static final long serialVersionUID = -5102133230630399469L;
    private static final String TEXT1 = I18n.tr("FrostWire is a Peer to Peer Application that enables you to share files of your choosing with other users connected to the BitTorrent network.");
    private static final String TEXT2 = I18n.tr("Installing and using the program does not constitute a license for obtaining or distributing unauthorized content.");

    WelcomeWindow(SetupManager setupManager, boolean bl) {
        super(setupManager, I18n.tr("Welcome"), bl ? I18n.tr("Welcome to the FrostWire setup wizard. FrostWire has recently added new features that require your configuration. FrostWire will guide you through a series of steps to configure these new features.") : I18n.tr("Welcome to the FrostWire setup wizard. FrostWire will guide you through a series of steps to configure FrostWire for optimum performance."));
    }

    @Override
    public Icon getIcon() {
        return GUIMediator.getThemeImage("logo");
    }

    @Override
    protected void createWindow() {
        super.createWindow();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JComponent jComponent = this.createPanel(TEXT1, TEXT2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this.setSetupComponent(jPanel);
    }

    private JComponent createPanel(String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.putClientProperty("CLIENT_PROPERTY_DARK_NOISE", true);
        jPanel.setBackground(GUIUtils.hexToColor("F7F7F7"));
        jPanel.setBorder(BorderFactory.createLineBorder(ThemeMediator.CURRENT_THEME.getCustomUI().getDarkBorder()));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        MultiLineLabel multiLineLabel = new MultiLineLabel(string, 400);
        multiLineLabel.setFont(multiLineLabel.getFont().deriveFont(16.0f));
        multiLineLabel.setForeground(GUIUtils.hexToColor("333333"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)multiLineLabel, gridBagConstraints);
        MultiLineLabel multiLineLabel2 = new MultiLineLabel(string2, 400);
        multiLineLabel2.setFont(multiLineLabel2.getFont().deriveFont(16.0f));
        multiLineLabel2.setForeground(GUIUtils.hexToColor("333333"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel.add((Component)multiLineLabel2, gridBagConstraints);
        MultiLineLabel multiLineLabel3 = new MultiLineLabel(I18n.tr("FrostWire is free software, "), 400);
        multiLineLabel3.setFont(multiLineLabel3.getFont().deriveFont(16.0f));
        multiLineLabel3.setForeground(GUIUtils.hexToColor("333333"));
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        jPanel.add((Component)multiLineLabel3, gridBagConstraints);
        URLLabel uRLLabel = new URLLabel("http://www.frostwire.com/scams", I18n.tr("Do not pay for FrostWire."));
        uRLLabel.setFont(uRLLabel.getFont().deriveFont(16.0f));
        uRLLabel.setForeground(GUIUtils.hexToColor("333333"));
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)uRLLabel, gridBagConstraints);
        return jPanel;
    }
}

