/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.OpenLinkAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.event.ActionEvent;
import org.limewire.util.OSUtils;

final class HelpMenu
extends AbstractMenu {
    HelpMenu() {
        super(I18n.tr("Sharing &Help"));
        this.addMenuItem(new OpenLinkAction("http://www.frostwire.com/?id=faq", I18n.tr("&FAQ"), I18n.tr("Frequently Asked Questions for FrostWire")));
        this.addMenuItem(new OpenLinkAction("http://www.frostwire.com/android", I18n.tr("FrostWire for Android"), I18n.tr("Get FrostWire on your Android phone, tablet or google tv, all free.")));
        this.addMenuItem(new OpenLinkAction("http://www.frostwire.com/?id=faq#fil7", I18n.tr("What is \"Seeding\"?"), I18n.tr("Learn about BitTorrent Seeding")));
        this.addSeparator();
        this.addMenuItem(new OpenLinkAction("http://www.frostwire.com/stickers", I18n.tr("Free FrostWire Stickers"), I18n.tr("Order free FrostWire stickers, we ship worldwide. Stickers are free, you pay cents for shipping.")));
        this.addMenuItem(new OpenLinkAction("http://www.frostwire.com/shop", I18n.tr("FrostWire T-Shirts"), I18n.tr("Get a T-shirt, support the project. You'll get also 10 free stickers")));
        this.addMenuItem(new OpenLinkAction("http://www.frostclick.com/wp/?from=frostwire" + FrostWireUtils.getFrostWireVersion(), I18n.tr("FrostClick.com"), I18n.tr("Free Legal Downloads")));
        this.addSeparator();
        this.addMenuItem(new OpenLinkAction("http://www.facebook.com/pages/FrostWire/110265295669948", I18n.tr("FrostWire on Facebook"), I18n.tr("Come and say hi to the community on Facebook")));
        this.addMenuItem(new OpenLinkAction("http://twitter.com/#!/frostwire", I18n.tr("Follow us on Twitter"), I18n.tr("Follow us on Twitter")));
        this.addMenuItem(new OpenLinkAction("http://www.frostwire.com/forum/viewforum.php?f=1", I18n.tr("Foru&m"), I18n.tr("Access the FrostWire Users' Forum")));
        this.addSeparator();
        this.addMenuItem(new OpenLinkAction("http://frostwire.wordpress.com/2012/02/14/dont-get-scammed-frostwire-is-free/", I18n.tr("&Did you pay for FrostWire?"), I18n.tr("Did you pay for FrostWire? FrostWire is Free as in Free Beer. Avoid Scams.")));
        this.addMenuItem(new ShowTipOfTheDayAction());
        if (!OSUtils.isMacOSX()) {
            this.addSeparator();
            this.addMenuItem(new ShowAboutDialogAction());
        }
    }

    private static class ShowAboutDialogAction
    extends AbstractAction {
        private static final long serialVersionUID = 2425666944873627828L;

        public ShowAboutDialogAction() {
            super(I18n.tr("&About FrostWire"));
            this.putValue("LongDescription", I18n.tr("Information about FrostWire"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.showAboutWindow();
        }
    }

    private static class ShowTipOfTheDayAction
    extends AbstractAction {
        private static final long serialVersionUID = -4964160055694967725L;

        public ShowTipOfTheDayAction() {
            super(I18n.tr("Tip of the &Day"));
            this.putValue("LongDescription", I18n.tr("Show the Tip of the Day Window"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TipOfTheDayMediator.instance().displayTipWindow();
        }
    }
}

