/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSetter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

final class ThemeMenu
extends AbstractMenu {
    private static final String THEME_OBJECT = "THEME_OBJECT";
    private static final Action THEME_CHANGER = new ThemeChangeAction();
    private static final ButtonGroup GROUP = new ButtonGroup();

    ThemeMenu() {
        super(I18n.tr("&Apply Skins"));
        JMenuItem jMenuItem = this.addMenuItem(THEME_CHANGER);
        jMenuItem.putClientProperty(THEME_OBJECT, ThemeMediator.DEFAULT_THEME);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ThemeMenu.setSelection(ThemeMediator.DEFAULT_THEME);
            }
        });
        this.addSeparator();
        this.addThemeItems();
    }

    private static void setSelection(Object object) {
        Enumeration<AbstractButton> enumeration = GROUP.getElements();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
            if (!object.equals(jMenuItem.getClientProperty(THEME_OBJECT))) continue;
            jMenuItem.setSelected(true);
            break;
        }
    }

    private void addThemeItems() {
        TreeSet<Object> treeSet = new TreeSet<Object>(new ThemeComparator());
        treeSet.addAll(ThemeMediator.loadThemes());
        for (ThemeSetter themeSetter : treeSet) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(themeSetter.getName());
            jRadioButtonMenuItem.putClientProperty(THEME_OBJECT, themeSetter);
            jRadioButtonMenuItem.setSelected(themeSetter.equals(ThemeMediator.CURRENT_THEME));
            jRadioButtonMenuItem.setFont(AbstractMenu.FONT);
            GROUP.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(THEME_CHANGER);
            this.MENU.add(jRadioButtonMenuItem);
        }
    }

    private static class ThemeComparator
    implements Comparator<Object> {
        private ThemeComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            String string = ((ThemeSetter)object).getName();
            String string2 = ((ThemeSetter)object2).getName();
            return string.compareTo(string2);
        }
    }

    protected static class ThemeChangeAction
    extends AbstractAction {
        private static final long serialVersionUID = -1905875579976154693L;

        public ThemeChangeAction() {
            super(I18n.tr("Use &Default"));
            this.putValue("LongDescription", I18n.tr("Use your default skin"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            ThemeSetter themeSetter = (ThemeSetter)jMenuItem.getClientProperty(ThemeMenu.THEME_OBJECT);
            ThemeMediator.changeTheme(themeSetter);
        }
    }
}

