/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.frostwire.gui.updates.UpdateMediator;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.OSUtils;

final class ToolsMenu
extends AbstractMenu {
    private final UpdateAction updateAction = new UpdateAction();

    ToolsMenu() {
        super(I18n.tr("&Tools"));
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            this.addMenuItem(new RebuildiTunesPlaylist());
        }
        this.addMenuItem(new ShowOptionsAction());
        this.addMenuItem(this.updateAction);
    }

    @Override
    protected void refresh() {
        this.updateAction.refresh();
    }

    private static class UpdateAction
    extends AbstractAction {
        private static final long serialVersionUID = 2915214339056016808L;

        public UpdateAction() {
            super(I18n.tr("&Update FrostWire"));
            this.putValue("LongDescription", I18n.tr("Update FrostWire to the latest version"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (UpdateMediator.instance().isUpdateDownloaded()) {
                UpdateMediator.instance().startUpdate();
            } else {
                UpdateMediator.instance().checkForUpdate();
            }
        }

        public void refresh() {
            if (UpdateMediator.instance().isUpdated()) {
                String string = I18n.tr("You are up to date with FrostWire") + " " + "v." + UpdateMediator.instance().getLatestVersion();
                this.putValue("Name", string);
                this.putValue("LongDescription", string);
                this.setEnabled(false);
            } else if (UpdateMediator.instance().isUpdateDownloading()) {
                String string = I18n.tr("Downloading update...");
                this.putValue("Name", string);
                this.putValue("LongDescription", string);
                this.setEnabled(false);
            } else if (UpdateMediator.instance().isUpdateDownloaded()) {
                String string = I18n.tr("Install update") + " " + "v." + UpdateMediator.instance().getLatestVersion();
                this.putValue("Name", string);
                this.putValue("LongDescription", string);
                this.setEnabled(true);
            } else {
                String string = I18n.tr("Check for update");
                this.putValue("Name", string);
                this.putValue("LongDescription", string);
                this.setEnabled(true);
            }
        }
    }

    private static class ShowOptionsAction
    extends AbstractAction {
        private static final long serialVersionUID = 6187597973189408647L;

        public ShowOptionsAction() {
            super(I18n.tr("&Options"));
            this.putValue("LongDescription", I18nMarker.marktr("Display the Options Screen"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.instance().setOptionsVisible(true);
        }
    }

    private static class RebuildiTunesPlaylist
    extends AbstractAction {
        private static final long serialVersionUID = 8348355619323878579L;

        public RebuildiTunesPlaylist() {
            super(I18n.tr("Rebuild iTunes \"FrostWire\" Playlist"));
            this.putValue("LongDescription", I18nMarker.marktr("Deletes and re-builds the \"FrostWire\" playlist on iTunes with all the audio files found on your Torrent Data Folder."));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog(GUIMediator.getAppFrame(), I18n.tr("This will remove your \"FrostWire\" playlist in iTunes and replace\nit with one containing all the iTunes compatible files in your \nFrostwire \"Torrent Data Folder\"\n\nPlease note that it will add the files to the iTunes library as well\nand this could result in duplicate files on your iTunes library\n\nAre you sure you want to continue?"), I18n.tr("Warning"), 2, 2);
            if (n == 0) {
                iTunesMediator.instance().resetFrostWirePlaylist();
            }
        }
    }
}

