/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LanguageWindow;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.ToggleSettingAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.menu.ThemeMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.event.ActionEvent;
import org.limewire.setting.BooleanSetting;

final class ViewMenu
extends AbstractMenu {
    ViewMenu(String string) {
        super(I18n.tr("&View"));
        this.MENU.add(new ThemeMenu().getMenu());
        this.MENU.addSeparator();
        ToggleSettingAction toggleSettingAction = new ToggleIconSettingAction(UISettings.SMALL_ICONS, I18n.tr("Use &Small Icons"), I18n.tr("Use Small Icons"));
        this.addToggleMenuItem(toggleSettingAction);
        toggleSettingAction = new ToggleIconSettingAction(UISettings.TEXT_WITH_ICONS, I18n.tr("Show Icon &Text"), I18n.tr("Show Text Below Icons"));
        this.addToggleMenuItem(toggleSettingAction);
        toggleSettingAction = new ToggleSmileySettingAction(UISettings.SMILEYS_IN_CHAT, I18n.tr("Show Smi&leys"), I18n.tr("Show emoticons in chat"));
        this.addToggleMenuItem(toggleSettingAction);
        this.addMenuItem(new ChangeFontSizeAction(2, I18n.tr("&Increase Font Size"), I18n.tr("Increases the Font Size")));
        this.addMenuItem(new ChangeFontSizeAction(-2, I18n.tr("&Decrease Font Size"), I18n.tr("Decreases the Font Size")));
        this.addMenuItem(new ResetFontSizeAction());
        this.MENU.addSeparator();
        this.addMenuItem(new ShowLanguageWindowAction());
    }

    private static class ChangeFontSizeAction
    extends AbstractAction {
        private static final long serialVersionUID = -6517433597971721717L;
        private final int increment;

        public ChangeFontSizeAction(int n, String string, String string2) {
            super(string);
            this.putValue("LongDescription", string2);
            this.increment = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = ThemeSettings.FONT_SIZE_INCREMENT.getValue();
            ThemeSettings.FONT_SIZE_INCREMENT.setValue(n += this.increment);
            ThemeMediator.setFontSizeDelta(this.increment);
            ThemeMediator.updateComponentHierarchy();
        }
    }

    private static class ResetFontSizeAction
    extends AbstractAction {
        private static final long serialVersionUID = -4678340681263959986L;

        public ResetFontSizeAction() {
            super(I18n.tr("Reset Font Size"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ThemeMediator.resetFontSizes();
        }
    }

    private static class ToggleSmileySettingAction
    extends ToggleSettingAction {
        private static final long serialVersionUID = -1098362918446138044L;
        public static BooleanSetting newsetting;

        public ToggleSmileySettingAction(BooleanSetting booleanSetting, String string, String string2) {
            super(booleanSetting, string, string2);
            newsetting = booleanSetting;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            System.out.println("new smiley setting from menu: " + newsetting.getValue());
            GUIMediator.instance().smileysChanged(newsetting.getValue());
        }
    }

    private static class ToggleIconSettingAction
    extends ToggleSettingAction {
        private static final long serialVersionUID = -4953235635397552198L;

        public ToggleIconSettingAction(BooleanSetting booleanSetting, String string, String string2) {
            super(booleanSetting, string, string2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            GUIMediator.instance().buttonViewChanged();
        }
    }

    private static class ShowLanguageWindowAction
    extends AbstractAction {
        private static final long serialVersionUID = -6305934985012530356L;

        public ShowLanguageWindowAction() {
            super(I18n.tr("C&hange Language"));
            this.putValue("LongDescription", I18n.tr("Select your Language Prefereces"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LanguageWindow languageWindow = new LanguageWindow();
            GUIUtils.centerOnScreen(languageWindow);
            languageWindow.setVisible(true);
        }
    }
}

