/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.notify.AnimatedWindowEvent;
import com.limegroup.gnutella.gui.notify.AnimatedWindowListener;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnimatedWindow
extends JWindow {
    private static final long serialVersionUID = 1764619610298463956L;
    private static final int ANIMATION_INTERVAL = 10;
    private static final int MOVE_PER_INTERVAL = 1;
    private static final float FADE_PER_INTERVAL = 0.015f;
    private static final Log LOG = LogFactory.getLog(AnimatedWindow.class);
    public static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    private AnimationMode mode = AnimationMode.BOTTOM_TO_TOP;
    private Timer animationTimer;
    private BufferedImage animationImage;
    private boolean hideOnClick;
    private int initialHeight;
    private Point finalLocation;
    private float opacity;
    private BufferedImage backgroundImage;
    private List<AnimatedWindowListener> listeners;
    private AnimationType currentAnimation;
    private Container contentPane;

    public AnimatedWindow(Window window) {
        super(window);
    }

    public Color getContentBackground() {
        return this.getContentPane().getBackground();
    }

    protected void autoHideWindow() {
        this.doHide();
    }

    public void doHide() {
        if (this.currentAnimation == AnimationType.HIDE) {
            return;
        }
        this.stopAnimations(true);
        final Point point = this.getLocation();
        this.prepareAnimation(point);
        this.currentAnimation = AnimationType.HIDE;
        this.animationTimer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = AnimatedWindow.this.mode.animateHide(AnimatedWindow.this, point);
                if (bl) {
                    AnimatedWindow.this.currentAnimation = null;
                    AnimatedWindow.this.animationTimer.stop();
                    AnimatedWindow.this.disposeAnimation();
                    AnimatedWindow.this.setVisible(false);
                    AnimatedWindow.this.fireAnimationCompleted(AnimationType.HIDE);
                }
            }
        });
        this.animationTimer.setRepeats(true);
        this.animationTimer.start();
    }

    public void doShow() {
        if (this.currentAnimation == AnimationType.SHOW) {
            return;
        }
        this.stopAnimations(true);
        final Dimension dimension = this.getPreferredSize();
        final Point point = this.getFinalLocation();
        this.prepareAnimation(point);
        if (!this.isVisible()) {
            this.mode.initializeWindow(this, point);
            this.setVisible(true);
        }
        this.currentAnimation = AnimationType.SHOW;
        this.animationTimer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = AnimatedWindow.this.mode.animateShow(AnimatedWindow.this, point);
                if (bl) {
                    if (point.y != AnimatedWindow.this.getLocation().y || (double)dimension.height != AnimatedWindow.this.getSize().getHeight()) {
                        AnimatedWindow.this.setBounds(point.x, point.y, dimension.width, dimension.height);
                    }
                    AnimatedWindow.this.animationImage = null;
                    AnimatedWindow.this.stopAnimations(false);
                    AnimatedWindow.this.validate();
                    AnimatedWindow.this.fireAnimationCompleted(AnimationType.SHOW);
                }
            }
        });
        this.animationTimer.setRepeats(true);
        this.animationTimer.start();
    }

    public int getInitialHeight() {
        return this.initialHeight;
    }

    public void setInitialHeight(int n) {
        this.initialHeight = n;
    }

    private void prepareAnimation(Point point) {
        Object object;
        if (this.animationImage != null) {
            return;
        }
        this.pack();
        Dimension dimension = this.getSize();
        if (this.mode.needsBackgroundImage() && this.backgroundImage == null) {
            try {
                object = new Robot();
                this.backgroundImage = ((Robot)object).createScreenCapture(new Rectangle(point, dimension));
            }
            catch (AWTException aWTException) {
                LOG.warn("Could not capture background image", aWTException);
                this.backgroundImage = null;
            }
        }
        this.animationImage = this.getGraphicsConfiguration().createCompatibleImage(dimension.width, dimension.height);
        object = this.animationImage.getGraphics();
        this.getContentPane().paint((Graphics)object);
        ((Graphics)object).dispose();
    }

    private void disposeAnimation() {
        this.animationImage = null;
        this.backgroundImage = null;
    }

    public Point getDefaultParentLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point(dimension.width - 1, dimension.height - 1);
    }

    public Dimension getDefaultParentSize() {
        return new Dimension(0, 0);
    }

    public void hideWindow() {
        this.doHide();
    }

    public void hideWindowImmediately() {
        this.stopAnimations(true);
        this.setVisible(false);
        this.disposeAnimation();
    }

    @Override
    public Container getContentPane() {
        if (this.contentPane == null) {
            this.setContentPane(new JPanel());
        }
        return this.contentPane;
    }

    @Override
    public void setContentPane(Container container) {
        this.contentPane = container;
        JPanel jPanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 1025231305407376307L;

            @Override
            public void paint(Graphics graphics) {
                if (AnimatedWindow.this.animationImage != null && AnimatedWindow.this.isAnimationInProgress()) {
                    AnimatedWindow.this.mode.paint(AnimatedWindow.this, graphics, AnimatedWindow.this.backgroundImage, AnimatedWindow.this.animationImage);
                } else {
                    super.paint(graphics);
                }
            }
        };
        jPanel.setDoubleBuffered(true);
        jPanel.add((Component)container, "Center");
        super.setContentPane(jPanel);
    }

    public boolean isAnimationInProgress() {
        return this.currentAnimation != null;
    }

    public boolean isHideAnimationInProgress() {
        return this.currentAnimation == AnimationType.HIDE;
    }

    public boolean isShowAnimationInProgress() {
        return this.currentAnimation == AnimationType.SHOW;
    }

    private void stopAnimations(boolean bl) {
        if (this.currentAnimation == null) {
            return;
        }
        this.currentAnimation = null;
        if (this.animationTimer != null) {
            this.animationTimer.stop();
        }
        if (bl) {
            this.fireAnimationStopped(this.currentAnimation);
        }
    }

    protected void fireAnimationStopped(AnimationType animationType) {
        if (this.listeners != null) {
            AnimatedWindowEvent animatedWindowEvent = new AnimatedWindowEvent(this, animationType);
            for (AnimatedWindowListener animatedWindowListener : this.listeners) {
                animatedWindowListener.animationStopped(animatedWindowEvent);
            }
        }
    }

    protected void fireAnimationCompleted(AnimationType animationType) {
        if (this.listeners != null) {
            AnimatedWindowEvent animatedWindowEvent = new AnimatedWindowEvent(this, animationType);
            for (AnimatedWindowListener animatedWindowListener : this.listeners) {
                animatedWindowListener.animationCompleted(animatedWindowEvent);
            }
        }
    }

    public boolean getHideOnClick() {
        return this.hideOnClick;
    }

    public void setHideOnClick(boolean bl) {
        this.hideOnClick = bl;
    }

    public AnimationMode getMode() {
        return this.mode;
    }

    public void setMode(AnimationMode animationMode) {
        if (animationMode == null) {
            throw new IllegalArgumentException();
        }
        this.mode = animationMode;
    }

    public static void main(String[] stringArray) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        JLabel jLabel = new JLabel("Hello World");
        jLabel.setIcon(UIManager.getIcon("FileView.computerIcon"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.add((Component)jLabel, "Center");
        final AnimatedWindow animatedWindow = new AnimatedWindow(null);
        animatedWindow.setFinalLocation(new Point(200, 200));
        animatedWindow.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 10, 10));
        JButton jButton = new JButton("Bottom -> Top");
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                animatedWindow.setMode(AnimationMode.BOTTOM_TO_TOP);
                if (!animatedWindow.isVisible() || animatedWindow.isHideAnimationInProgress()) {
                    animatedWindow.doShow();
                } else {
                    animatedWindow.doHide();
                }
            }
        });
        jButton = new JButton("Top -> Bottom");
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                animatedWindow.setMode(AnimationMode.TOP_TO_BOTTOM);
                if (!animatedWindow.isVisible() || animatedWindow.isHideAnimationInProgress()) {
                    animatedWindow.doShow();
                } else {
                    animatedWindow.doHide();
                }
            }
        });
        jButton = new JButton("Fade");
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                animatedWindow.setMode(AnimationMode.FADE);
                if (!animatedWindow.isVisible() || animatedWindow.isHideAnimationInProgress()) {
                    animatedWindow.doShow();
                } else {
                    animatedWindow.doHide();
                }
            }
        });
        JFrame jFrame = new JFrame("AnimatedWindow Demo");
        jFrame.setContentPane(jPanel2);
        jFrame.pack();
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }

    public Point getFinalLocation() {
        return this.finalLocation;
    }

    public void setFinalLocation(Point point) {
        this.finalLocation = point;
    }

    public float getOpacity2() {
        return this.opacity;
    }

    public void setOpacity2(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.opacity = f;
    }

    public void addAnimatedWindowListener(AnimatedWindowListener animatedWindowListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<AnimatedWindowListener>();
        }
        this.listeners.add(animatedWindowListener);
    }

    public void removeAnimatedWindowListener(AnimatedWindowListener animatedWindowListener) {
        if (this.listeners != null) {
            this.listeners.remove(animatedWindowListener);
        }
    }

    public static enum AnimationMode {
        TOP_TO_BOTTOM,
        BOTTOM_TO_TOP,
        FADE;


        public boolean movesWindow() {
            switch (this) {
                case TOP_TO_BOTTOM: 
                case BOTTOM_TO_TOP: {
                    return true;
                }
                case FADE: {
                    return false;
                }
            }
            throw new RuntimeException("Unknown mode: " + (Object)((Object)this));
        }

        public boolean needsBackgroundImage() {
            switch (this) {
                case FADE: {
                    return true;
                }
            }
            return false;
        }

        public void initializeWindow(AnimatedWindow animatedWindow, Point point) {
            Dimension dimension = animatedWindow.getPreferredSize();
            switch (this) {
                case BOTTOM_TO_TOP: {
                    if (animatedWindow.getContentBackground() != null) {
                        animatedWindow.setBackground(animatedWindow.getContentBackground());
                    }
                    animatedWindow.setBounds(point.x, point.y + dimension.height - animatedWindow.getInitialHeight(), dimension.width, animatedWindow.getInitialHeight());
                    animatedWindow.setOpacity2(1.0f);
                    break;
                }
                case TOP_TO_BOTTOM: {
                    if (animatedWindow.getContentBackground() != null) {
                        animatedWindow.setBackground(animatedWindow.getContentBackground());
                    }
                    animatedWindow.setBounds(point.x, point.y, dimension.width, animatedWindow.getInitialHeight());
                    animatedWindow.setOpacity2(1.0f);
                    break;
                }
                case FADE: {
                    animatedWindow.setBounds(point.x, point.y, dimension.width, dimension.height);
                    animatedWindow.setOpacity2(0.0f);
                    animatedWindow.setBackground(TRANSPARENT);
                }
            }
        }

        public boolean animateShow(AnimatedWindow animatedWindow, Point point) {
            Dimension dimension = animatedWindow.getPreferredSize();
            switch (this) {
                case BOTTOM_TO_TOP: {
                    if (animatedWindow.getHeight() >= dimension.height) {
                        return true;
                    }
                    int n = Math.min(animatedWindow.getHeight() + 1, dimension.height);
                    animatedWindow.setBounds(point.x, point.y + dimension.height - n, dimension.width, n);
                    animatedWindow.validate();
                    return false;
                }
                case TOP_TO_BOTTOM: {
                    if (animatedWindow.getHeight() >= dimension.height) {
                        return true;
                    }
                    animatedWindow.setBounds(point.x, point.y, dimension.width, Math.min(animatedWindow.getHeight() + 1, dimension.height));
                    animatedWindow.validate();
                    return false;
                }
                case FADE: {
                    if (animatedWindow.getOpacity2() >= 1.0f) {
                        return true;
                    }
                    animatedWindow.setOpacity2(Math.min(animatedWindow.getOpacity2() + 0.015f, 1.0f));
                    animatedWindow.repaint();
                    return false;
                }
            }
            return true;
        }

        public boolean animateHide(AnimatedWindow animatedWindow, Point point) {
            Dimension dimension = animatedWindow.getPreferredSize();
            switch (this) {
                case BOTTOM_TO_TOP: {
                    if (animatedWindow.getHeight() == 0) {
                        return true;
                    }
                    int n = Math.max(animatedWindow.getHeight() - 1, 0);
                    try {
                        animatedWindow.setBounds(point.x, point.y + dimension.height - n, dimension.width, n);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOG.warn("IAE setting bounds", illegalArgumentException);
                    }
                    animatedWindow.validate();
                    return false;
                }
                case TOP_TO_BOTTOM: {
                    if (animatedWindow.getHeight() == 0) {
                        return true;
                    }
                    animatedWindow.setSize(dimension.width, Math.max(animatedWindow.getHeight() - 1, 0));
                    animatedWindow.validate();
                    return false;
                }
                case FADE: {
                    if (animatedWindow.getOpacity2() == 0.0f) {
                        return true;
                    }
                    animatedWindow.setOpacity2(Math.max(animatedWindow.getOpacity2() - 0.015f, 0.0f));
                    animatedWindow.repaint();
                    return false;
                }
            }
            return true;
        }

        public void paint(AnimatedWindow animatedWindow, Graphics graphics, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            switch (this) {
                case BOTTOM_TO_TOP: {
                    graphics.drawImage(bufferedImage2, 0, 0, null);
                    break;
                }
                case TOP_TO_BOTTOM: {
                    graphics.drawImage(bufferedImage2, 0, animatedWindow.getHeight() - animatedWindow.getPreferredSize().height, null);
                    break;
                }
                case FADE: {
                    if (bufferedImage != null) {
                        graphics.drawImage(bufferedImage, 0, 0, null);
                    } else {
                        graphics.setColor(Color.white);
                        graphics.fillRect(0, 0, animatedWindow.getWidth(), animatedWindow.getHeight());
                    }
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, animatedWindow.getOpacity2());
                    graphics2D.setComposite(alphaComposite);
                    graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
                    graphics2D.dispose();
                }
            }
        }
    }

    public static enum AnimationType {
        SHOW,
        HIDE;

    }
}

