/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.notify.AnimatedWindow;
import com.limegroup.gnutella.gui.notify.AnimatedWindowEvent;
import com.limegroup.gnutella.gui.notify.AnimatedWindowListener;
import com.limegroup.gnutella.gui.notify.DefaultNotificationRenderer;
import com.limegroup.gnutella.gui.notify.NotificationRenderer;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.themes.SkinHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

public class NotificationWindow
extends AnimatedWindow {
    private static final long serialVersionUID = 7826381963144231497L;
    private static final int DEFAULT_TIMEOUT = 6000;
    private JLabel titleLabel;
    private Timer autoHideTimer;
    private String title;
    private JPanel mainPanel;
    private Icon titleIcon;
    private Point parentLocation;
    private Dimension parentSize;
    private BoxPanel topPanel;
    private ComboBoxModel model;
    private ModelListener modelListener = new ModelListener();
    private NotificationRenderer renderer = new DefaultNotificationRenderer();
    private Action previousNotificationAction = new PreviousNotificationAction();
    private Action nextNotificationAction = new NextNotificationAction();
    private Action closeAction = new CloseAction();
    private JLabel notificationIndexLabel;
    private Dimension locationOffset = new Dimension(0, 0);
    private boolean pendingScreenUpdate;

    public NotificationWindow(Window window, ComboBoxModel comboBoxModel) {
        super(window);
        this.setModel(comboBoxModel);
        this.initialize();
        this.autoHideTimer = new Timer(6000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NotificationWindow.this.showNextNotificationOrHideWindow();
            }
        });
        this.autoHideTimer.setRepeats(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                NotificationWindow.this.stopAutoHideTimer();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                NotificationWindow.this.startAutoHideTimer();
            }
        });
        this.addAnimatedWindowListener(new AnimatedWindowListener(){

            @Override
            public void animationCompleted(AnimatedWindowEvent animatedWindowEvent) {
                if (animatedWindowEvent.getAnimationType() == AnimatedWindow.AnimationType.SHOW) {
                    if (NotificationWindow.this.pendingScreenUpdate) {
                        NotificationWindow.this.pendingScreenUpdate = false;
                        NotificationWindow.this.doNotificationLayout();
                    }
                    NotificationWindow.this.startAutoHideTimer();
                }
            }

            @Override
            public void animationStarted(AnimatedWindowEvent animatedWindowEvent) {
            }

            @Override
            public void animationStopped(AnimatedWindowEvent animatedWindowEvent) {
            }
        });
    }

    public NotificationWindow(Window window) {
        this(window, new DefaultComboBoxModel());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SystemUtils.setWindowTopMost(this);
    }

    public void addNotification(Object object) {
        ((MutableComboBoxModel)this.model).addElement(object);
    }

    private void doNotificationLayout() {
        if (this.isHideAnimationInProgress()) {
            this.pendingScreenUpdate = true;
            this.doShow();
            return;
        }
        if (this.isShowAnimationInProgress()) {
            this.pendingScreenUpdate = true;
            return;
        }
        this.titleLabel.setIcon(this.getIcon());
        this.titleLabel.setText(this.getTitle());
        this.setInitialHeight(this.titleLabel.getPreferredSize().height + 10);
        int n = this.getSelectedIndex();
        if (n != -1) {
            this.notificationIndexLabel.setText(n + 1 + " of " + this.getModel().getSize());
            this.previousNotificationAction.setEnabled(n > 0);
            this.nextNotificationAction.setEnabled(n < this.getNotficationCount() - 1);
        } else {
            this.notificationIndexLabel.setText("");
            this.previousNotificationAction.setEnabled(false);
            this.nextNotificationAction.setEnabled(false);
        }
        Component component = this.getRenderer().getNotificationRendererComponent(this, this.model.getSelectedItem(), n);
        this.mainPanel.add(component, "Center");
        this.pack();
        this.ensureVisibility();
    }

    @Override
    public Point getFinalLocation() {
        AnimatedWindow.AnimationMode animationMode;
        Rectangle rectangle;
        Insets insets;
        Point point = new Point(this.getParentLocation() != null ? this.getParentLocation() : this.getDefaultParentLocation());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration(point);
        if (graphicsConfiguration != null) {
            insets = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle = graphicsConfiguration.getBounds();
        } else {
            insets = new Insets(0, 0, 0, 0);
            rectangle = new Rectangle(toolkit.getScreenSize());
        }
        int n = rectangle.width - Math.abs(insets.left + insets.right);
        int n2 = rectangle.height - Math.abs(insets.top + insets.bottom);
        Dimension dimension = new Dimension(this.getParentSize() != null ? this.getParentSize() : this.getDefaultParentSize());
        point.x -= this.getLocationOffset().width;
        point.y -= this.getLocationOffset().height;
        dimension.width += this.getLocationOffset().width * 2;
        dimension.height += this.getLocationOffset().height * 2;
        Dimension dimension2 = this.getPreferredSize();
        Point point2 = new Point();
        if (point.y - dimension2.height > 0) {
            animationMode = AnimatedWindow.AnimationMode.BOTTOM_TO_TOP;
            point2.y = point.y - dimension2.height;
        } else {
            animationMode = AnimatedWindow.AnimationMode.TOP_TO_BOTTOM;
            point2.y = point.y + dimension.height;
        }
        point2.x = point.x;
        if (point2.x + dimension2.width > rectangle.x + n) {
            point2.x = rectangle.x + n - dimension2.width - 1;
        }
        if (point2.y + dimension2.height > rectangle.y + n2) {
            point2.y = rectangle.y + n2 - dimension2.height - 1;
        }
        if (point2.x < rectangle.x) {
            point2.x = rectangle.x;
        }
        if (point2.y < rectangle.y) {
            point2.y = rectangle.y;
        }
        if (OSUtils.isMacOSX()) {
            this.setMode(AnimatedWindow.AnimationMode.FADE);
        } else {
            this.setMode(animationMode);
        }
        return point2;
    }

    private GraphicsConfiguration getGraphicsConfiguration(Point point) {
        GraphicsDevice[] graphicsDeviceArray;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration;
            if (graphicsDevice.getType() != 0 || !(graphicsConfiguration = graphicsDevice.getDefaultConfiguration()).getBounds().contains(point)) continue;
            return graphicsConfiguration;
        }
        return null;
    }

    private void ensureVisibility() {
        if (!this.isVisible()) {
            return;
        }
        this.setLocation(this.getFinalLocation());
    }

    public int getAutoHideTimeout() {
        return this.autoHideTimer.getDelay();
    }

    @Override
    public Point getDefaultParentLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point(dimension.width - 1, dimension.height - 1);
    }

    @Override
    public Dimension getDefaultParentSize() {
        return new Dimension(0, 0);
    }

    public Icon getIcon() {
        return this.titleIcon;
    }

    public Dimension getLocationOffset() {
        return this.locationOffset;
    }

    public ComboBoxModel getModel() {
        return this.model;
    }

    public int getNotficationCount() {
        return this.model.getSize();
    }

    public Point getParentLocation() {
        return this.parentLocation;
    }

    public Dimension getParentSize() {
        return this.parentSize;
    }

    public NotificationRenderer getRenderer() {
        return this.renderer;
    }

    public int getSelectedIndex() {
        Object object = this.model.getSelectedItem();
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.model.getElementAt(i);
            if (e == null || !e.equals(object)) continue;
            return i;
        }
        return -1;
    }

    public Object getSelectedNotification() {
        return this.model.getSelectedItem();
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void hideWindow() {
        this.doHide();
    }

    private void initialize() {
        this.setAlwaysOnTop(true);
        this.mainPanel = new MainPanel(new BorderLayout(0, 10));
        this.mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black, 2), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.mainPanel.setOpaque(true);
        this.setContentPane(this.mainPanel);
        this.topPanel = new BoxPanel(0);
        this.topPanel.setOpaque(false);
        this.mainPanel.add((Component)this.topPanel, "North");
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(new Font("SansSerif", 1, 12));
        this.topPanel.add(this.titleLabel);
        this.topPanel.add(Box.createHorizontalStrut(10));
        this.topPanel.add(Box.createHorizontalGlue());
        IconButton iconButton = new IconButton(this.previousNotificationAction);
        iconButton.setIcon(GUIMediator.getThemeImage("notification-back_up.gif"));
        iconButton.setPressedIcon(GUIMediator.getThemeImage("notification-back_dn.gif"));
        this.topPanel.add(iconButton);
        this.topPanel.add(Box.createHorizontalStrut(3));
        this.notificationIndexLabel = new JLabel();
        this.notificationIndexLabel.setFont(new Font("SansSerif", 0, 12));
        this.topPanel.add(this.notificationIndexLabel);
        this.topPanel.add(Box.createHorizontalStrut(3));
        IconButton iconButton2 = new IconButton(this.nextNotificationAction);
        iconButton2.setIcon(GUIMediator.getThemeImage("notification-forward_up.gif"));
        iconButton2.setPressedIcon(GUIMediator.getThemeImage("notification-forward_dn.gif"));
        this.topPanel.add(iconButton2);
        this.topPanel.add(Box.createHorizontalStrut(5));
        IconButton iconButton3 = new IconButton(this.closeAction);
        iconButton3.setIcon(GUIMediator.getThemeImage("kill.png"));
        iconButton3.setRolloverIcon(GUIMediator.getThemeImage("kill_on.png"));
        this.topPanel.add(iconButton3);
    }

    public void removeAllNotifications() {
        if (this.model instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)this.model).removeAllElements();
        } else {
            MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.model;
            int n = this.model.getSize();
            for (int i = 0; i < n; ++i) {
                Object e = this.model.getElementAt(0);
                mutableComboBoxModel.removeElement(e);
            }
        }
    }

    public void removeNotification(Object object) {
        ((MutableComboBoxModel)this.model).removeElement(object);
    }

    public void setAutoHideTimeout(int n) {
        this.autoHideTimer.setDelay(n);
    }

    public void setLocationOffset(Dimension dimension) {
        this.locationOffset = dimension;
    }

    public void setIcon(Icon icon) {
        this.titleIcon = icon;
        this.doNotificationLayout();
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        ComboBoxModel comboBoxModel2 = this.model;
        if (comboBoxModel2 != null) {
            comboBoxModel2.removeListDataListener(this.modelListener);
        }
        this.model = comboBoxModel;
        comboBoxModel.addListDataListener(this.modelListener);
        this.firePropertyChange("model", comboBoxModel2, comboBoxModel);
    }

    public void setParentLocation(Point point) {
        this.parentLocation = point;
    }

    public void setParentSize(Dimension dimension) {
        this.parentSize = dimension;
    }

    public void setRenderer(NotificationRenderer notificationRenderer) {
        this.renderer = notificationRenderer;
    }

    public void setSelectedNotification(Object object) {
        this.model.setSelectedItem(object);
    }

    public void setTitle(String string) {
        this.title = string;
        this.doNotificationLayout();
    }

    public void showWindow() {
        if (this.isVisible()) {
            return;
        }
        this.doShow();
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl) {
            this.removeAllNotifications();
            this.stopAutoHideTimer();
        }
        super.setVisible(bl);
    }

    public void showNextNotificationOrHideWindow() {
        if (!this.showNextNotification()) {
            this.doHide();
        }
    }

    public boolean showNextNotification() {
        int n = this.getSelectedIndex();
        if (n != -1 && n < this.getNotficationCount() - 1) {
            this.model.setSelectedItem(this.model.getElementAt(n + 1));
            return true;
        }
        return false;
    }

    public boolean showPreviousNotification() {
        int n = this.getSelectedIndex();
        if (n != -1 && n > 0) {
            this.model.setSelectedItem(this.model.getElementAt(n - 1));
            return true;
        }
        return false;
    }

    public void startAutoHideTimer() {
        this.autoHideTimer.start();
    }

    public void stopAutoHideTimer() {
        this.autoHideTimer.stop();
    }

    public class MainPanel
    extends JPanel {
        private static final long serialVersionUID = -5156001841794524934L;
        private Ditherer DITHERER;

        public MainPanel(LayoutManager layoutManager) {
            super(layoutManager);
            this.DITHERER = new Ditherer(62, SkinHandler.getSearchPanelBG1(), SkinHandler.getSearchPanelBG2());
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!this.DITHERER.getFromColor().equals(this.DITHERER.getToColor())) {
                Dimension dimension = this.getSize();
                this.DITHERER.draw(graphics, dimension.height, dimension.width);
            } else {
                super.paintComponent(graphics);
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.DITHERER = new Ditherer(62, SkinHandler.getSearchPanelBG1(), SkinHandler.getSearchPanelBG2());
            this.setBackground(SkinHandler.getSearchPanelBG2());
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = -7970545406830868291L;

        public CloseAction() {
            this.putValue("Name", "X");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NotificationWindow.this.hideWindowImmediately();
        }
    }

    private class PreviousNotificationAction
    extends AbstractAction {
        private static final long serialVersionUID = 8634646312072477295L;

        public PreviousNotificationAction() {
            this.putValue("Name", "<");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NotificationWindow.this.showPreviousNotification();
        }
    }

    private class NextNotificationAction
    extends AbstractAction {
        private static final long serialVersionUID = 9025502192496019505L;

        public NextNotificationAction() {
            this.putValue("Name", ">");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NotificationWindow.this.showNextNotification();
        }
    }

    private class ModelListener
    implements ListDataListener {
        private ModelListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            NotificationWindow.this.doNotificationLayout();
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            NotificationWindow.this.doNotificationLayout();
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            NotificationWindow.this.doNotificationLayout();
        }
    }

    private class IconButton
    extends JButton {
        private static final long serialVersionUID = -8670595793783875510L;

        public IconButton(Action action) {
            super(action);
            this.setText("");
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusable(false);
            if (this.getIcon() != null) {
                this.setPreferredSize(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
            } else {
                this.setPreferredSize(null);
            }
            this.setMargin(new Insets(0, 0, 0, 0));
        }
    }
}

