/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.notify.BasicNotifier;
import com.limegroup.gnutella.gui.notify.Notification;
import com.limegroup.gnutella.gui.notify.NotifyUser;
import com.limegroup.gnutella.gui.notify.TrayNotifier;
import com.limegroup.gnutella.settings.UISettings;
import org.limewire.util.OSUtils;

public class NotifyUserProxy
implements NotifyUser {
    private static final NotifyUserProxy INSTANCE = new NotifyUserProxy();
    private NotifyUser _notifier;
    private boolean _inTray;

    public static NotifyUserProxy instance() {
        return INSTANCE;
    }

    private NotifyUserProxy() {
        if (OSUtils.supportsTray()) {
            this._notifier = new TrayNotifier();
            if (!this.showTrayIcon()) {
                this._notifier = new BasicNotifier();
            }
        } else {
            this._notifier = new BasicNotifier();
        }
    }

    @Override
    public boolean supportsSystemTray() {
        return this._notifier.supportsSystemTray();
    }

    @Override
    public boolean showTrayIcon() {
        if (this._inTray) {
            return true;
        }
        boolean bl = this._notifier.showTrayIcon();
        this._inTray = true;
        return bl;
    }

    @Override
    public void hideTrayIcon() {
        if (!this._inTray) {
            return;
        }
        this._notifier.hideTrayIcon();
        this._inTray = false;
    }

    @Override
    public void updateUI() {
        this._notifier.updateUI();
    }

    @Override
    public void hideMessage(Notification notification) {
        this._notifier.hideMessage(notification);
    }

    @Override
    public void showMessage(Notification notification) {
        if (!UISettings.SHOW_NOTIFICATIONS.getValue() || OSUtils.isMacOSX()) {
            return;
        }
        this._notifier.showMessage(notification);
    }
}

