/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.notify.DefaultNotificationRenderer;
import com.limegroup.gnutella.gui.notify.Notification;
import com.limegroup.gnutella.gui.notify.NotificationWindow;
import com.limegroup.gnutella.gui.notify.NotifyUser;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.OSUtils;

public class TrayNotifier
implements NotifyUser {
    private static final Log LOG = LogFactory.getLog(DefaultNotificationRenderer.class);
    private SystemTray _tray;
    private TrayIcon _icon;
    private NotificationWindow notificationWindow;
    private boolean _supportsTray;

    public TrayNotifier() {
        try {
            this._tray = SystemTray.getSystemTray();
        }
        catch (Exception exception) {
            this._tray = null;
            this._supportsTray = false;
            return;
        }
        this._supportsTray = true;
        this.buildPopupMenu();
        String string = "frosticon";
        if (OSUtils.isLinux()) {
            string = string + "_linux";
        }
        this.buildTrayIcon(I18n.tr("FrostWire"), string);
        this.buildNotificationWindow();
    }

    private void buildTrayIcon(String string, String string2) {
        this._icon = new TrayIcon(GUIMediator.getThemeImage(string2).getImage(), string, GUIMediator.getTrayMenu());
        this._icon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiersEx() & 0x400) == 1024) {
                    GUIMediator.restoreView();
                }
            }
        });
        this._icon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.restoreView();
            }
        });
        this._icon.setImageAutoSize(true);
    }

    private PopupMenu buildPopupMenu() {
        PopupMenu popupMenu = GUIMediator.getTrayMenu();
        MenuItem menuItem = new MenuItem(I18n.tr("Restore"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.restoreView();
            }
        });
        popupMenu.add(menuItem);
        popupMenu.addSeparator();
        menuItem = new MenuItem(I18n.tr("About"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.showAboutWindow();
            }
        });
        popupMenu.add(menuItem);
        popupMenu.addSeparator();
        menuItem = new MenuItem(I18n.tr("Exit"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.shutdown();
            }
        });
        popupMenu.add(menuItem);
        return popupMenu;
    }

    private void buildNotificationWindow() {
        this.notificationWindow = new NotificationWindow((Window)GUIMediator.getAppFrame());
        this.notificationWindow.setLocationOffset(new Dimension(2, 7));
        this.notificationWindow.setTitle("FrostWire");
        this.notificationWindow.setIcon(GUIMediator.getThemeImage("frosticon.gif"));
    }

    @Override
    public boolean showTrayIcon() {
        if (this._tray == null || !this.supportsSystemTray()) {
            return false;
        }
        try {
            this._tray.add(this._icon);
        }
        catch (Exception exception) {
            return false;
        }
        this.notificationWindow.setParentSize(new Dimension(22, 22));
        return true;
    }

    @Override
    public boolean supportsSystemTray() {
        return this._supportsTray;
    }

    @Override
    public void hideTrayIcon() {
        this._tray.remove(this._icon);
        this.notificationWindow.setParentLocation(null);
        this.notificationWindow.setParentSize(null);
    }

    @Override
    public void showMessage(Notification notification) {
        try {
            this.notificationWindow.addNotification(notification);
            try {
                this.notificationWindow.setParentLocation(this.getTryIconLocation(this._icon));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notificationWindow.showWindow();
        }
        catch (Exception exception) {
            LOG.error("Disabling notifications due to error", exception);
            UISettings.SHOW_NOTIFICATIONS.setValue(false);
            this.notificationWindow.hideWindowImmediately();
        }
    }

    @Override
    public void hideMessage(Notification notification) {
        this.notificationWindow.removeNotification(notification);
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.notificationWindow);
    }

    private Point getTryIconLocation(TrayIcon trayIcon) throws Exception {
        Field field = trayIcon.getClass().getDeclaredField("peer");
        field.setAccessible(true);
        Object object = field.get(trayIcon);
        Field field2 = object.getClass().getDeclaredField("eframe");
        field2.setAccessible(true);
        Object object2 = field2.get(object);
        Component component = (Component)object2;
        Point point = component.getLocation();
        SwingUtilities.convertPointToScreen(point, component);
        return point;
    }
}

