/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.frostwire.gui.components.SearchField;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.options.OptionsButtonPanel;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.OptionsPaneManager;
import com.limegroup.gnutella.gui.options.OptionsTreeManager;
import com.limegroup.gnutella.gui.options.OptionsTreeNode;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.options.panes.AssociationPreferencePaneItem;
import com.limegroup.gnutella.gui.options.panes.AudioPlayerPaneItem;
import com.limegroup.gnutella.gui.options.panes.AutoCompletePaneItem;
import com.limegroup.gnutella.gui.options.panes.AutomaticInstallerDownloadPaneItem;
import com.limegroup.gnutella.gui.options.panes.BrowserPaneItem;
import com.limegroup.gnutella.gui.options.panes.BugsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ChatCommunityPaneItem;
import com.limegroup.gnutella.gui.options.panes.DetailsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ForceIPPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreResultsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ImageViewerPaneItem;
import com.limegroup.gnutella.gui.options.panes.LibraryFoldersPaneItem;
import com.limegroup.gnutella.gui.options.panes.LibraryInternetRadioPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumSearchesPaneItem;
import com.limegroup.gnutella.gui.options.panes.NetworkInterfacePaneItem;
import com.limegroup.gnutella.gui.options.panes.NotificationsPaneItem;
import com.limegroup.gnutella.gui.options.panes.PopupsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ProxyLoginPaneItem;
import com.limegroup.gnutella.gui.options.panes.ProxyPaneItem;
import com.limegroup.gnutella.gui.options.panes.ShowPromoOverlaysPaneItem;
import com.limegroup.gnutella.gui.options.panes.ShutdownPaneItem;
import com.limegroup.gnutella.gui.options.panes.SmartSearchDBPaneItem;
import com.limegroup.gnutella.gui.options.panes.StartupPaneItem;
import com.limegroup.gnutella.gui.options.panes.StatusBarBandwidthPaneItem;
import com.limegroup.gnutella.gui.options.panes.StatusBarConnectionQualityPaneItem;
import com.limegroup.gnutella.gui.options.panes.StatusBarFirewallPaneItem;
import com.limegroup.gnutella.gui.options.panes.TorrentConnectionPaneItem;
import com.limegroup.gnutella.gui.options.panes.TorrentGlobalSpeedPaneItem;
import com.limegroup.gnutella.gui.options.panes.TorrentSaveFolderPaneItem;
import com.limegroup.gnutella.gui.options.panes.TorrentSeedingSettingPaneItem;
import com.limegroup.gnutella.gui.options.panes.VideoPlayerPaneItem;
import com.limegroup.gnutella.gui.options.panes.iTunesPreferencePaneItem;
import com.limegroup.gnutella.gui.shell.FrostAssociations;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.limewire.setting.IntSetting;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.OSUtils;

public final class OptionsConstructor {
    private final JDialog DIALOG;
    private final OptionsTreeManager TREE_MANAGER;
    private final OptionsPaneManager PANE_MANAGER;
    private final SearchField filterTextField;
    static final String SAVE_KEY = "OPTIONS_SAVE_MAIN_TITLE";
    static final String SAVE_BASIC_KEY = "OPTIONS_SAVE_BASIC_MAIN_TITLE";
    static final String SAVE_ADVANCED_KEY = "OPTIONS_SAVE_ADVANCED_MAIN_TITLE";
    public static final String SHARED_KEY = "OPTIONS_SHARED_MAIN_TITLE";
    static final String SHARED_BASIC_KEY = "OPTIONS_SHARED_BASIC_TITLE";
    static final String SHARED_ADVANCED_KEY = "OPTIONS_SHARED_ADVANCED_MAIN_TITLE";
    static final String SHARED_TYPES_KEY = "OPTIONS_SHARED_TYPES_MAIN_TITLE";
    static final String SPEED_KEY = "OPTIONS_SPEED_MAIN_TITLE";
    static final String DOWNLOAD_KEY = "OPTIONS_DOWNLOAD_MAIN_TITLE";
    static final String UPLOAD_KEY = "OPTIONS_UPLOAD_MAIN_TITLE";
    static final String UPLOAD_BASIC_KEY = "OPTIONS_UPLOAD_BASIC_MAIN_TITLE";
    static final String UPLOAD_SLOTS_KEY = "OPTIONS_UPLOAD_SLOTS_MAIN_TITLE";
    static final String CONNECTIONS_KEY = "OPTIONS_CONNECTIONS_MAIN_TITLE";
    static final String BITTORRENT_KEY = "OPTIONS_BITTORRENT_MAIN_TITLE";
    static final String BITTORRENT_BASIC_KEY = "OPTIONS_BITTORRENT_BASIC_TITLE";
    static final String BITTORRENT_ADVANCED_KEY = "OPTIONS_BITTORRENT_ADVANCED_TITLE";
    static final String SHUTDOWN_KEY = "OPTIONS_SHUTDOWN_MAIN_TITLE";
    static final String UPDATE_KEY = "OPTIONS_UPDATE_MAIN_TITLE";
    static final String CHAT_KEY = "OPTIONS_CHAT_MAIN_TITLE";
    public static final String LIBRARY_KEY = "OPTIONS_LIBRARY_MAIN_TITLE";
    static final String STATUS_BAR_KEY = "OPTIONS_STATUS_BAR_MAIN_TITLE";
    static final String ITUNES_KEY = "OPTIONS_ITUNES_MAIN_TITLE";
    static final String ITUNES_IMPORT_KEY = "OPTIONS_ITUNES_PREFERENCE_MAIN_TITLE";
    static final String ITUNES_DAAP_KEY = "OPTIONS_ITUNES_DAAP_MAIN_TITLE";
    static final String POPUPS_KEY = "OPTIONS_POPUPS_MAIN_TITLE";
    static final String BUGS_KEY = "OPTIONS_BUGS_MAIN_TITLE";
    static final String APPS_KEY = "OPTIONS_APPS_MAIN_TITLE";
    static final String SEARCH_KEY = "OPTIONS_SEARCH_MAIN_TITLE";
    static final String SEARCH_LIMIT_KEY = "OPTIONS_SEARCH_LIMIT_MAIN_TITLE";
    static final String SEARCH_QUALITY_KEY = "OPTIONS_SEARCH_QUALITY_MAIN_TITLE";
    static final String SEARCH_SPEED_KEY = "OPTIONS_SEARCH_SPEED_MAIN_TITLE";
    public static final String CONTENT_FILTER_KEY = "OPTIONS_CONTENT_FILTER_MAIN_TITLE";
    static final String SEARCH_JUNK_KEY = "OPTIONS_SEARCH_JUNK_MAIN_TITLE";
    static final String FILTERS_KEY = "OPTIONS_FILTERS_MAIN_TITLE";
    static final String RESULTS_KEY = "OPTIONS_RESULTS_MAIN_TITLE";
    static final String MESSAGES_KEY = "OPTIONS_MESSAGES_MAIN_TITLE";
    static final String ADVANCED_KEY = "OPTIONS_ADVANCED_MAIN_TITLE";
    static final String PREFERENCING_KEY = "OPTIONS_PREFERENCING_MAIN_TITLE";
    static final String FIREWALL_KEY = "OPTIONS_FIREWALL_MAIN_TITLE";
    static final String GUI_KEY = "OPTIONS_GUI_MAIN_TITLE";
    static final String AUTOCOMPLETE_KEY = "OPTIONS_AUTOCOMPLETE_MAIN_TITLE";
    static final String SHOW_PROMOTION_OVERLAYS_KEY = "OPTIONS_SHOW_PROMOTION_OVERLAYS_MAIN_TITLE";
    static final String STARTUP_KEY = "OPTIONS_STARTUP_MAIN_TITLE";
    static final String PROXY_KEY = "OPTIONS_PROXY_MAIN_TITLE";
    static final String NETWORK_INTERFACE_KEY = "OPTIONS_NETWORK_INTERFACE_MAIN_TITLE";
    static final String ASSOCIATIONS_KEY = "OPTIONS_ASSOCIATIONS_MAIN_TITLE";
    static final String PERFORMANCE_KEY = "OPTIONS_PERFORMANCE_MAIN_TITLE";
    static final String STORE_KEY = "OPTIONS_STORE_MAIN_TITLE";
    static final String STORE_BASIC_KEY = "OPTIONS_STORE_BASIC_MAIN_TITLE";
    static final String STORE_ADVANCED_KEY = "OPTIONS_STORE_ADVANCED_MAIN_TITLE";

    public OptionsConstructor(OptionsTreeManager optionsTreeManager, OptionsPaneManager optionsPaneManager) {
        this.TREE_MANAGER = optionsTreeManager;
        this.PANE_MANAGER = optionsPaneManager;
        String string = I18n.tr("Options");
        boolean bl = !OSUtils.isMacOSX();
        this.DIALOG = new JDialog(GUIMediator.getAppFrame(), string, bl);
        this.DIALOG.setDefaultCloseOperation(0);
        GUIUtils.addHideAction((JComponent)this.DIALOG.getContentPane());
        if (UISettings.UI_OPTIONS_DIALOG_HEIGHT.getValue() < UISettings.UI_OPTIONS_DIALOG_HEIGHT.getDefaultValue()) {
            UISettings.UI_OPTIONS_DIALOG_HEIGHT.revertToDefault();
        }
        if (UISettings.UI_OPTIONS_DIALOG_WIDTH.getValue() < UISettings.UI_OPTIONS_DIALOG_WIDTH.getDefaultValue()) {
            UISettings.UI_OPTIONS_DIALOG_WIDTH.revertToDefault();
        }
        DialogSizeSettingUpdater.install(this.DIALOG, UISettings.UI_OPTIONS_DIALOG_WIDTH, UISettings.UI_OPTIONS_DIALOG_HEIGHT);
        this.DIALOG.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                try {
                    DialogOption dialogOption = null;
                    if (OptionsMediator.instance().isDirty() && (dialogOption = GUIMediator.showYesNoCancelMessage(I18n.tr("You have made changes to some of FrostWire's settings. Would you like to save these changes?"))) == DialogOption.YES) {
                        OptionsMediator.instance().applyOptions();
                        SettingsGroupManager.instance().save();
                    }
                    if (dialogOption != DialogOption.CANCEL) {
                        OptionsConstructor.this.DIALOG.dispose();
                        OptionsMediator.instance().disposeOptions();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        PaddedPanel paddedPanel = new PaddedPanel();
        paddedPanel.putClientProperty("CLIENT_PROPERTY_LIGHT_NOISE", true);
        Box box = new Box(0);
        BoxPanel boxPanel = new BoxPanel(1);
        BoxPanel boxPanel2 = new BoxPanel(0);
        boxPanel.add(boxPanel2);
        this.filterTextField = new SearchField();
        this.filterTextField.setPrompt(I18n.tr("Search here"));
        this.filterTextField.setMinimumSize(new Dimension(100, 27));
        this.filterTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsConstructor.this.filter();
            }
        });
        boxPanel2.add(this.filterTextField);
        boxPanel2.add(Box.createHorizontalStrut(2));
        boxPanel.add(Box.createVerticalStrut(3));
        Component component = this.TREE_MANAGER.getComponent();
        boxPanel.add(component);
        Component component2 = this.PANE_MANAGER.getComponent();
        box.add(boxPanel);
        box.add(component2);
        paddedPanel.add(box);
        paddedPanel.add(Box.createVerticalStrut(17));
        paddedPanel.add(new OptionsButtonPanel().getComponent());
        this.DIALOG.getContentPane().add(paddedPanel);
        OptionsTreeNode optionsTreeNode = this.initializePanels();
        this.PANE_MANAGER.show(optionsTreeNode);
    }

    private OptionsTreeNode initializePanels() {
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", BITTORRENT_KEY, I18n.tr("BitTorrent"));
        OptionsTreeNode optionsTreeNode = this.addOption(BITTORRENT_KEY, BITTORRENT_BASIC_KEY, I18n.tr("Basic"), TorrentSaveFolderPaneItem.class, TorrentSeedingSettingPaneItem.class);
        this.addOption(BITTORRENT_KEY, BITTORRENT_ADVANCED_KEY, I18n.tr("Advanced"), TorrentGlobalSpeedPaneItem.class, TorrentConnectionPaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", LIBRARY_KEY, I18n.tr("Library"), LibraryFoldersPaneItem.class, LibraryInternetRadioPaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", SEARCH_KEY, I18n.tr("Searching"), MaximumSearchesPaneItem.class, SmartSearchDBPaneItem.class, DetailsPaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", STATUS_BAR_KEY, I18n.tr("Status Bar"), StatusBarConnectionQualityPaneItem.class, StatusBarFirewallPaneItem.class, StatusBarBandwidthPaneItem.class);
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            this.addGroupTreeNode("OPTIONS_ROOT_NODE", ITUNES_KEY, I18n.tr("iTunes"));
            this.addOption(ITUNES_KEY, ITUNES_IMPORT_KEY, I18n.tr("Importing"), iTunesPreferencePaneItem.class);
        }
        if (!OSUtils.isWindows() && !OSUtils.isAnyMac()) {
            this.addOption("OPTIONS_ROOT_NODE", APPS_KEY, I18n.tr("Helper Apps"), BrowserPaneItem.class, ImageViewerPaneItem.class, VideoPlayerPaneItem.class, AudioPlayerPaneItem.class);
        }
        this.addOption("OPTIONS_ROOT_NODE", GUI_KEY, I18n.tr("View"), PopupsPaneItem.class, NotificationsPaneItem.class, ShowPromoOverlaysPaneItem.class, AutoCompletePaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", CHAT_KEY, I18n.tr("Community Chat"), ChatCommunityPaneItem.class);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", FILTERS_KEY, I18n.tr("Filters"));
        this.addOption(FILTERS_KEY, RESULTS_KEY, I18n.tr("Keywords"), IgnoreResultsPaneItem.class);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", ADVANCED_KEY, I18n.tr("Advanced"));
        this.addOption(ADVANCED_KEY, PREFERENCING_KEY, I18n.tr("Updates"), AutomaticInstallerDownloadPaneItem.class);
        this.addOption(ADVANCED_KEY, FIREWALL_KEY, I18n.tr("Firewall"), ForceIPPaneItem.class);
        this.addOption(ADVANCED_KEY, PROXY_KEY, I18n.tr("Proxy"), ProxyPaneItem.class, ProxyLoginPaneItem.class);
        this.addOption(ADVANCED_KEY, NETWORK_INTERFACE_KEY, I18n.tr("Network Interface"), NetworkInterfacePaneItem.class);
        if (FrostAssociations.anyAssociationsSupported()) {
            this.addOption(ADVANCED_KEY, ASSOCIATIONS_KEY, I18n.tr("File Associations"), AssociationPreferencePaneItem.class);
        }
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            this.addOption(ADVANCED_KEY, STARTUP_KEY, I18n.tr("System Boot"), StartupPaneItem.class);
        }
        this.addOption("OPTIONS_ROOT_NODE", SHUTDOWN_KEY, I18n.tr("System Tray"), ShutdownPaneItem.class);
        this.addOption("OPTIONS_ROOT_NODE", BUGS_KEY, I18n.tr("Bug Reports"), BugsPaneItem.class);
        return optionsTreeNode;
    }

    private final void addGroupTreeNode(String string, String string2, String string3) {
        this.TREE_MANAGER.addNode(string, string2, string3, string3);
    }

    private final OptionsTreeNode addOption(String string, String string2, String string3, Class<? extends AbstractPaneItem> ... classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append(" ");
        stringBuilder.append(this.extractLabels(classArray));
        OptionsTreeNode optionsTreeNode = this.TREE_MANAGER.addNode(string, string2, string3, stringBuilder.toString());
        optionsTreeNode.setClasses(classArray);
        return optionsTreeNode;
    }

    private String extractLabels(Class<?> ... classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Class<?> clazz : classArray) {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz.getFields()) {
                if ((field.getModifiers() & 0x10) == 0 || field.getType() != String.class) continue;
                try {
                    stringBuilder.append(field.get(null));
                    stringBuilder.append(" ");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return stringBuilder.toString();
    }

    final void setOptionsVisible(boolean bl, String string) {
        if (!bl) {
            this.DIALOG.dispose();
            OptionsMediator.instance().disposeOptions();
        } else {
            GUIUtils.centerOnScreen(this.DIALOG);
            if (string == null) {
                this.TREE_MANAGER.setDefaultSelection();
            } else {
                this.TREE_MANAGER.setSelection(string);
            }
            this.TREE_MANAGER.getComponent().requestFocusInWindow();
            this.DIALOG.setVisible(true);
        }
    }

    public final boolean isOptionsVisible() {
        return this.DIALOG.isVisible();
    }

    JDialog getMainOptionsComponent() {
        return this.DIALOG;
    }

    private void filter() {
        this.TREE_MANAGER.setFilterText(this.filterTextField.getText());
    }

    public static class DialogSizeSettingUpdater {
        public static void install(JDialog jDialog, IntSetting intSetting, IntSetting intSetting2) {
            int n = ThemeSettings.FONT_SIZE_INCREMENT.getValue();
            int n2 = intSetting.isDefault() ? DialogSizeSettingUpdater.getWidthForFontIncrement(intSetting, jDialog, n) : intSetting.getValue();
            int n3 = intSetting2.isDefault() ? DialogSizeSettingUpdater.getHeightForFontIncrement(intSetting2, jDialog, n) : intSetting2.getValue();
            jDialog.setSize(n2, n3);
            jDialog.addComponentListener(new SizeChangeListener(intSetting, intSetting2));
        }

        private static int getWidthForFontIncrement(IntSetting intSetting, Component component, int n) {
            if (n > 0) {
                return intSetting.getValue() + 20 * n + 4 * n ^ 2;
            }
            return intSetting.getValue();
        }

        private static int getHeightForFontIncrement(IntSetting intSetting, Component component, int n) {
            if (n > 0) {
                return intSetting.getValue() + 10 * n + 18 * n ^ 2;
            }
            return intSetting.getValue();
        }

        private static class SizeChangeListener
        extends ComponentAdapter {
            private IntSetting widthSetting;
            private IntSetting heightSetting;

            public SizeChangeListener(IntSetting intSetting, IntSetting intSetting2) {
                this.widthSetting = intSetting;
                this.heightSetting = intSetting2;
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                int n = ThemeSettings.FONT_SIZE_INCREMENT.getValue();
                Component component = componentEvent.getComponent();
                if (component.getWidth() != DialogSizeSettingUpdater.getWidthForFontIncrement(this.widthSetting, component, n) || component.getHeight() != DialogSizeSettingUpdater.getHeightForFontIncrement(this.heightSetting, component, n)) {
                    this.widthSetting.setValue(component.getWidth());
                    this.heightSetting.setValue(component.getHeight());
                }
            }
        }
    }
}

