/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SettingsWarningManager;
import com.limegroup.gnutella.gui.options.OptionsPane;
import com.limegroup.gnutella.gui.options.OptionsPaneFactory;
import com.limegroup.gnutella.gui.options.OptionsTreeNode;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public final class OptionsPaneManager {
    private final JPanel MAIN_PANEL = new JPanel();
    private final CardLayout CARD_LAYOUT = new CardLayout();
    private final List<OptionsPane> OPTIONS_PANE_LIST = new ArrayList<OptionsPane>();
    private final Map<String, OptionsPane> panesByKey = new HashMap<String, OptionsPane>();
    private final OptionsPaneFactory FACTORY = new OptionsPaneFactory();

    public OptionsPaneManager() {
        this.MAIN_PANEL.setLayout(this.CARD_LAYOUT);
    }

    public final void show(OptionsTreeNode optionsTreeNode) {
        if (!this.panesByKey.containsKey(optionsTreeNode.getTitleKey())) {
            OptionsPane optionsPane = this.FACTORY.createOptionsPane(optionsTreeNode);
            optionsPane.initOptions();
            this.addPane(optionsPane);
            this.panesByKey.put(optionsTreeNode.getTitleKey(), optionsPane);
            if (optionsTreeNode.getTitleKey().equals("OPTIONS_SAVE_BASIC_MAIN_TITLE") && !this.panesByKey.containsKey("OPTIONS_SHARED_BASIC_TITLE")) {
                OptionsPane optionsPane2 = this.FACTORY.createOptionsPane(optionsTreeNode);
                optionsPane2.initOptions();
                this.addPane(optionsPane2);
                this.panesByKey.put(optionsTreeNode.getTitleKey(), optionsPane2);
            }
        }
        this.CARD_LAYOUT.show(this.MAIN_PANEL, optionsTreeNode.getTitleKey());
    }

    public void initOptions() {
        int n = this.OPTIONS_PANE_LIST.size();
        for (int i = 0; i < n; ++i) {
            OptionsPane optionsPane = this.OPTIONS_PANE_LIST.get(i);
            optionsPane.initOptions();
        }
    }

    public final void applyOptions() throws IOException {
        boolean bl = false;
        int n = this.OPTIONS_PANE_LIST.size();
        for (int i = 0; i < n; ++i) {
            OptionsPane optionsPane = this.OPTIONS_PANE_LIST.get(i);
            bl |= optionsPane.applyOptions();
        }
        if (bl) {
            GUIMediator.showMessage(I18n.tr("One or more options will take effect the next time FrostWire is restarted."));
        }
        SettingsWarningManager.checkSettingsLoadSaveFailure();
    }

    public final boolean isDirty() {
        int n = this.OPTIONS_PANE_LIST.size();
        for (int i = 0; i < n; ++i) {
            OptionsPane optionsPane = this.OPTIONS_PANE_LIST.get(i);
            if (!optionsPane.isDirty()) continue;
            return true;
        }
        return false;
    }

    public final Component getComponent() {
        return this.MAIN_PANEL;
    }

    public final void addPane(OptionsPane optionsPane) {
        this.MAIN_PANEL.add((Component)optionsPane.getContainer(), optionsPane.getName());
        this.OPTIONS_PANE_LIST.add(optionsPane);
    }
}

