/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.TitledPaddedPanel;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.options.panes.PaneItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.Box;

public abstract class AbstractPaneItem
implements PaneItem {
    private final TitledPaddedPanel CONTAINER = new TitledPaddedPanel();
    private final int LABEL_WIDTH = 415;

    protected AbstractPaneItem(String string, String string2) {
        this(string, string2, null);
    }

    protected AbstractPaneItem(String string, String string2, String string3) {
        this.CONTAINER.setTitle(string);
        this.add(Box.createHorizontalGlue());
        MultiLineLabel multiLineLabel = new MultiLineLabel(string2, 415, true);
        GUIUtils.restrictSize(multiLineLabel, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
        this.add(multiLineLabel);
        this.add(this.getVerticalSeparator());
        if (string3 != null) {
            this.add(new URLLabel(string3, I18n.tr("Learn more about this option...")));
            this.add(this.getVerticalSeparator());
        }
    }

    protected void addLabel(String string) {
        MultiLineLabel multiLineLabel = new MultiLineLabel(string, 415, true);
        GUIUtils.restrictSize(multiLineLabel, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
        this.add(multiLineLabel);
    }

    @Override
    public Container getContainer() {
        return this.CONTAINER;
    }

    @Override
    public abstract void initOptions();

    @Override
    public abstract boolean applyOptions() throws IOException;

    protected final void add(Component component) {
        this.CONTAINER.add(component);
    }

    protected final Component getHorizontalSeparator() {
        return Box.createRigidArea(new Dimension(6, 0));
    }

    protected final Component getVerticalSeparator() {
        return Box.createRigidArea(new Dimension(0, 6));
    }
}

