/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.URLHandlerSettings;
import java.io.IOException;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;

public class BrowserPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Browser Options");
    public static final String LABEL = I18n.tr("You can choose which browser to use.");
    private final String OPTION_LABEL = I18nMarker.marktr("Browser");
    private JTextField BROWSER = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);

    public BrowserPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.OPTION_LABEL, this.BROWSER);
        this.add(labeledComponent.getComponent());
    }

    @Override
    public boolean applyOptions() throws IOException {
        URLHandlerSettings.BROWSER.setValue(this.BROWSER.getText());
        return false;
    }

    @Override
    public boolean isDirty() {
        return !URLHandlerSettings.BROWSER.getValue().equals(this.BROWSER.getText());
    }

    @Override
    public void initOptions() {
        this.BROWSER.setText(URLHandlerSettings.BROWSER.getValue());
    }
}

