/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ContentSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public class ContentFilterPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Content Filters");
    public static final String LABEL = I18n.tr("You can tell FrostWire to filter files that copyright owners request not be shared. By enabling filtering, you are instructing FrostWire to confirm all files you download or share with a list of removed content.");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public ContentFilterPaneItem() {
        super(TITLE, LABEL, ContentSettings.LEARN_MORE_URL);
        LabeledComponent labeledComponent = new LabeledComponent(I18nMarker.marktr("Enable Content Filters"), this.CHECK_BOX, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    @Override
    public void initOptions() {
        this.CHECK_BOX.setSelected(ContentSettings.USER_WANTS_MANAGEMENTS.getValue());
    }

    @Override
    public boolean applyOptions() throws IOException {
        ContentSettings.USER_WANTS_MANAGEMENTS.setValue(this.CHECK_BOX.isSelected());
        return false;
    }

    @Override
    public boolean isDirty() {
        return ContentSettings.USER_WANTS_MANAGEMENTS.getValue() != this.CHECK_BOX.isSelected();
    }
}

