/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.EventListener;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;

public final class ExtensionsPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Shared Extensions");
    public static final String LABEL = I18n.tr("You can choose which file extensions you would like to share.");
    private final String OPTION_LABEL = I18nMarker.marktr("Extensions:");
    private JTextField _extField = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
    private String _extensions;

    public ExtensionsPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.OPTION_LABEL, this._extField, 150, 13);
        String[] stringArray = new String[]{I18nMarker.marktr("Use Defaults")};
        String[] stringArray2 = new String[]{I18nMarker.marktr("Share the Default File Extensions")};
        EventListener[] eventListenerArray = new ActionListener[]{new DefaultExtensionsListener()};
        ButtonRow buttonRow = new ButtonRow(stringArray, stringArray2, eventListenerArray, 0, 12);
        this.add(labeledComponent.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(buttonRow);
    }

    @Override
    public void initOptions() {
        this._extensions = SharingSettings.EXTENSIONS_TO_SHARE.getValue();
        this._extField.setText(this._extensions);
    }

    @Override
    public boolean applyOptions() throws IOException {
        String string = this._extField.getText();
        if (!string.equals(this._extensions)) {
            SharingSettings.EXTENSIONS_TO_SHARE.setValue(this._extField.getText());
            this._extensions = this._extField.getText();
        }
        return false;
    }

    @Override
    public boolean isDirty() {
        return !SharingSettings.EXTENSIONS_TO_SHARE.getValue().equals(this._extField.getText());
    }

    private class DefaultExtensionsListener
    implements ActionListener {
        private DefaultExtensionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SharingSettings.EXTENSIONS_TO_SHARE.revertToDefault();
            ExtensionsPaneItem.this._extField.setText(SharingSettings.EXTENSIONS_TO_SHARE.getValue());
        }
    }
}

