/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.limewire.util.NetworkUtils;

public final class ForceIPPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Router Configuration");
    public static final String LABEL = I18n.tr("FrostWire can configure itself to work from behind a firewall or router. Using Universal Plug 'n Play (UPnP) and other NAT traversal techniques FrostWire can automatically configure your router or firewall for optimal performance. If your router does not support UPnP, FrostWire can be set to advertise an external port manually. (You may also have to configure your router if you choose manual configuration, but FrostWire will try its best so you don't have to.)");
    private final WholeNumberField TCP_PORT_FIELD = new SizedWholeNumberField();
    private final WholeNumberField UDP_PORT_FIELD = new SizedWholeNumberField();
    private final ButtonGroup BUTTONS = new ButtonGroup();
    private final JRadioButton RANDOM_PORT = new JRadioButton(I18n.tr("Use random port (Recommended)"));
    private final JRadioButton MANUAL_PORT = new JRadioButton(I18n.tr("Manual Port Forward"));
    private JLabel _labelTCP;
    private JLabel _labelUDP;

    public ForceIPPaneItem() {
        super(TITLE, LABEL);
        this.BUTTONS.add(this.RANDOM_PORT);
        this.BUTTONS.add(this.MANUAL_PORT);
        this.MANUAL_PORT.addItemListener(new LocalPortListener());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel.add((Component)this.RANDOM_PORT, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.MANUAL_PORT, gridBagConstraints);
        this._labelTCP = new JLabel(I18n.tr("TCP:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        jPanel.add((Component)this._labelTCP, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.TCP_PORT_FIELD, gridBagConstraints);
        this._labelUDP = new JLabel(I18n.tr("UDP:"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        jPanel.add((Component)this._labelUDP, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.UDP_PORT_FIELD, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add(Box.createGlue(), gridBagConstraints);
        GUIUtils.restrictSize(jPanel, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
        this.add(jPanel);
    }

    private void updateState() {
        this._labelTCP.setEnabled(this.MANUAL_PORT.isSelected());
        this._labelUDP.setEnabled(this.MANUAL_PORT.isSelected());
        this.TCP_PORT_FIELD.setEnabled(this.MANUAL_PORT.isSelected());
        this.UDP_PORT_FIELD.setEnabled(this.MANUAL_PORT.isSelected());
    }

    @Override
    public void initOptions() {
        if (ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue()) {
            this.MANUAL_PORT.setSelected(true);
        } else {
            this.RANDOM_PORT.setSelected(true);
        }
        this.TCP_PORT_FIELD.setValue(ConnectionSettings.TCP_PORT.getValue());
        this.UDP_PORT_FIELD.setValue(ConnectionSettings.UDP_PORT.getValue());
        this.updateState();
    }

    @Override
    public boolean applyOptions() throws IOException {
        boolean bl = false;
        boolean bl2 = ConnectionSettings.UPNP_IN_USE.getValue();
        if (this.RANDOM_PORT.isSelected()) {
            if (!ConnectionSettings.UPNP_IN_USE.getValue()) {
                ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
            }
            ConnectionSettings.DISABLE_UPNP.setValue(false);
            if (!bl2) {
                bl = true;
            }
            COConfigurationManager.setParameter("upnp.enable", true);
        } else {
            int n = this.TCP_PORT_FIELD.getValue();
            int n2 = this.UDP_PORT_FIELD.getValue();
            if (!NetworkUtils.isValidPort(n)) {
                GUIMediator.showError(I18n.tr("You must enter a port between 1 and 65535 when manually forcing your TCP port."));
                throw new IOException("bad port: " + n);
            }
            if (!NetworkUtils.isValidPort(n2)) {
                GUIMediator.showError(I18n.tr("You must enter a port between 1 and 65535 when manually forcing your UDP port."));
                throw new IOException("bad port: " + n2);
            }
            ConnectionSettings.DISABLE_UPNP.setValue(false);
            ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
            ConnectionSettings.UPNP_IN_USE.setValue(false);
            ConnectionSettings.TCP_PORT.setValue(n);
            ConnectionSettings.UDP_PORT.setValue(n2);
            COConfigurationManager.setParameter("TCP.Listen.Port", n);
            COConfigurationManager.setParameter("UDP.Listen.Port", n2);
            COConfigurationManager.setParameter("upnp.enable", false);
            bl = true;
        }
        COConfigurationManager.save();
        return bl;
    }

    @Override
    public boolean isDirty() {
        if (ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue() ? !this.MANUAL_PORT.isSelected() : !this.RANDOM_PORT.isSelected()) {
            return true;
        }
        return this.MANUAL_PORT.isSelected() && (this.TCP_PORT_FIELD.getValue() != ConnectionSettings.TCP_PORT.getValue() || this.UDP_PORT_FIELD.getValue() != ConnectionSettings.UDP_PORT.getValue());
    }

    private class LocalPortListener
    implements ItemListener {
        private LocalPortListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ForceIPPaneItem.this.updateState();
        }
    }
}

