/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ListEditor;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.FilterSettings;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class IgnoreResultsPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Filter Results");
    public static final String LABEL = I18n.tr("You can filter out search results containing specific words.");
    private final ListEditor RESULTS_LIST = new ListEditor();
    private JCheckBox IGNORE_ADULT_CHECK_BOX = new JCheckBox();
    private String ADULT_BOX_LABEL = I18nMarker.marktr("Ignore Adult Content");

    public IgnoreResultsPaneItem() {
        super(TITLE, LABEL);
        this.IGNORE_ADULT_CHECK_BOX.setText(I18n.tr(this.ADULT_BOX_LABEL));
        this.add(this.RESULTS_LIST);
        this.add(this.IGNORE_ADULT_CHECK_BOX);
    }

    @Override
    public void initOptions() {
        String[] stringArray = FilterSettings.BANNED_WORDS.getValue();
        this.RESULTS_LIST.setModel(new Vector<String>(Arrays.asList(stringArray)));
        this.IGNORE_ADULT_CHECK_BOX.setSelected(FilterSettings.FILTER_ADULT.getValue());
    }

    @Override
    public boolean applyOptions() throws IOException {
        Vector<String> vector = this.RESULTS_LIST.getModel();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        FilterSettings.BANNED_WORDS.setValue((String[])objectArray);
        FilterSettings.FILTER_ADULT.setValue(this.IGNORE_ADULT_CHECK_BOX.isSelected());
        return false;
    }

    @Override
    public boolean isDirty() {
        List<String> list = Arrays.asList(FilterSettings.BANNED_WORDS.getValue());
        return !((Object)list).equals(this.RESULTS_LIST.getModel()) || FilterSettings.FILTER_ADULT.getValue() != this.IGNORE_ADULT_CHECK_BOX.isSelected();
    }
}

