/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.frostwire.gui.library.AddLibraryDirectoryAction;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.RecursiveLibraryDirectoryPanel;
import com.frostwire.gui.library.RemoveLibraryDirectoryAction;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.LibrarySettings;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.limewire.util.FileUtils;

public final class LibraryFoldersPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Library Included Folders");
    public static final String LABEL = I18n.tr("You can choose the folders for include files when browsing the library.");
    private final JButton buttonAddLibraryDirectory;
    private final JButton buttonRemoveLibraryDirectory;
    private final RecursiveLibraryDirectoryPanel directoryPanel = new RecursiveLibraryDirectoryPanel(true, new File[0]);
    private Set<File> initialFoldersToInclude;
    private Set<File> initialFoldersToExclude;

    public LibraryFoldersPaneItem() {
        super(TITLE, LABEL);
        this.buttonAddLibraryDirectory = new JButton(new AddLibraryDirectoryAction(this.directoryPanel, this.directoryPanel));
        this.buttonRemoveLibraryDirectory = new JButton(new RemoveLibraryDirectoryAction(this.directoryPanel));
        this.directoryPanel.getTree().setRootVisible(false);
        this.directoryPanel.getTree().setShowsRootHandles(true);
        this.directoryPanel.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = treeSelectionEvent.getPath().getLastPathComponent();
                if (object instanceof File && object.equals(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue())) {
                    LibraryFoldersPaneItem.this.buttonRemoveLibraryDirectory.setEnabled(false);
                    return;
                }
                LibraryFoldersPaneItem.this.buttonRemoveLibraryDirectory.setEnabled(true);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.buttonAddLibraryDirectory, "North");
        jPanel2.add(Box.createVerticalStrut(4), "Center");
        jPanel2.add((Component)this.buttonRemoveLibraryDirectory, "South");
        jPanel.add((Component)jPanel2, "North");
        this.directoryPanel.addEastPanel(jPanel);
        this.add(this.directoryPanel);
    }

    void addAndKeepDirtyStatus(Set<File> set, Set<File> set2) {
        for (File file : set) {
            this.directoryPanel.addRoot(file);
        }
        this.directoryPanel.addFoldersToExclude(set2);
    }

    boolean isAlreadyGoingToBeIncluded(File file) {
        if (this.directoryPanel.getFoldersToExclude().contains(file)) {
            return false;
        }
        for (File file2 : this.directoryPanel.getRootsToInclude()) {
            if (!FileUtils.isAncestor(file2, file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initOptions() {
        this.initialFoldersToInclude = LibrarySettings.DIRECTORIES_TO_INCLUDE.getValue();
        this.initialFoldersToExclude = LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue();
        ArrayList<File> arrayList = new ArrayList<File>(LibrarySettings.DIRECTORIES_TO_INCLUDE.getValue());
        arrayList.addAll(LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.getValue());
        this.directoryPanel.setRoots(arrayList.toArray(new File[0]));
        this.directoryPanel.setFoldersToExclude(this.initialFoldersToExclude);
    }

    @Override
    public boolean applyOptions() throws IOException {
        LibrarySettings.DIRECTORIES_TO_INCLUDE.setValue(new HashSet());
        LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.setValue(new HashSet());
        for (File file : this.directoryPanel.getRootsToInclude()) {
            if (file == null) continue;
            LibrarySettings.DIRECTORIES_TO_INCLUDE.add(file);
        }
        for (File file : this.directoryPanel.getFoldersToExclude()) {
            if (file == null) continue;
            if (file.equals(SharingSettings.TORRENT_DATA_DIR_SETTING.getValue())) {
                LibrarySettings.DIRECTORIES_TO_INCLUDE.add(file);
                continue;
            }
            LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.add(file);
        }
        LibraryMediator.instance().clearDirectoryHolderCaches();
        return false;
    }

    @Override
    public boolean isDirty() {
        return !((Object)this.initialFoldersToInclude).equals(this.directoryPanel.getRootsToInclude()) || !((Object)this.initialFoldersToExclude).equals(this.directoryPanel.getFoldersToExclude());
    }
}

