/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.frostwire.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;

public final class LibraryInternetRadioPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Internet Radio Stations");
    public static final String LABEL = I18n.tr("You can restore the default internet radio stations.");
    private JLabel numRadioStationsLabel;
    private long numRadioStations = 0L;

    public LibraryInternetRadioPaneItem() {
        super(TITLE, LABEL);
        Font font = new Font("dialog", 1, 12);
        this.numRadioStationsLabel = new JLabel();
        this.numRadioStationsLabel.setFont(font);
        LabeledComponent labeledComponent = new LabeledComponent(I18n.tr("Total Radio Stations"), this.numRadioStationsLabel);
        this.add(this.getVerticalSeparator());
        JButton jButton = new JButton("Restore default Radio Stations");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.safeInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LibraryInternetRadioPaneItem.this.restoreDefaultRadioStations();
                        LibraryInternetRadioPaneItem.this.initOptions();
                    }
                });
            }
        });
        this.add(labeledComponent.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(jButton);
    }

    protected void restoreDefaultRadioStations() {
        LibraryMediator.instance().restoreDefaultRadioStations();
    }

    @Override
    public void initOptions() {
        this.numRadioStations = LibraryMediator.instance().getTotalRadioStations();
        this.numRadioStationsLabel.setText(String.valueOf(this.numRadioStations));
    }

    @Override
    public boolean applyOptions() throws IOException {
        return false;
    }

    @Override
    public boolean isDirty() {
        return false;
    }
}

