/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class LocalePreferencingPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Locale Preferencing");
    public static final String LABEL = I18n.tr("You can choose to preference hosts using the same language as you.");
    private final String LOCALE_PREF_LABEL_CHECK_BOX = I18nMarker.marktr("Turn preferencing on:");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public LocalePreferencingPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.LOCALE_PREF_LABEL_CHECK_BOX, this.CHECK_BOX, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    @Override
    public void initOptions() {
        this.CHECK_BOX.setSelected(ConnectionSettings.USE_LOCALE_PREF.getValue());
    }

    @Override
    public boolean applyOptions() throws IOException {
        ConnectionSettings.USE_LOCALE_PREF.setValue(this.CHECK_BOX.isSelected());
        return false;
    }

    @Override
    public boolean isDirty() {
        return ConnectionSettings.USE_LOCALE_PREF.getValue() != this.CHECK_BOX.isSelected();
    }
}

