/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.limewire.i18n.I18nMarker;

public final class ProxyLoginPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Login Details");
    public static final String LABEL = I18n.tr("Configure username and password to be used for the proxy.");
    private final String PROXY_AUTHENTICATE_CHECK_BOX_LABEL = I18nMarker.marktr("Enable Authentication (Does Not Work for HTTP Proxies):");
    private final String PROXY_USERNAME_LABEL_KEY = I18nMarker.marktr("Username:");
    private final String PROXY_PASSWORD_LABEL_KEY = I18nMarker.marktr("Password:");
    private final JTextField PROXY_USERNAME_FIELD = new SizedTextField(12, GUIUtils.SizePolicy.RESTRICT_BOTH);
    private final JTextField PROXY_PASSWORD_FIELD = new SizedTextField(12, GUIUtils.SizePolicy.RESTRICT_BOTH);
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public ProxyLoginPaneItem() {
        super(TITLE, LABEL);
        this.CHECK_BOX.addItemListener(new LocalAuthenticateListener());
        LabeledComponent labeledComponent = new LabeledComponent(this.PROXY_AUTHENTICATE_CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        LabeledComponent labeledComponent2 = new LabeledComponent(this.PROXY_USERNAME_LABEL_KEY, this.PROXY_USERNAME_FIELD, 120, 10);
        LabeledComponent labeledComponent3 = new LabeledComponent(this.PROXY_PASSWORD_LABEL_KEY, this.PROXY_PASSWORD_FIELD, 120, 10);
        this.add(labeledComponent.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(labeledComponent2.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(labeledComponent3.getComponent());
    }

    @Override
    public void initOptions() {
        String string = ConnectionSettings.PROXY_USERNAME.getValue();
        String string2 = ConnectionSettings.PROXY_PASS.getValue();
        boolean bl = ConnectionSettings.PROXY_AUTHENTICATE.getValue();
        this.PROXY_USERNAME_FIELD.setText(string);
        this.PROXY_PASSWORD_FIELD.setText(string2);
        this.CHECK_BOX.setSelected(bl && ConnectionSettings.CONNECTION_METHOD.getValue() != 1);
        this.updateState();
    }

    @Override
    public boolean applyOptions() throws IOException {
        String string = this.PROXY_USERNAME_FIELD.getText();
        String string2 = this.PROXY_PASSWORD_FIELD.getText();
        boolean bl = this.CHECK_BOX.isSelected();
        ConnectionSettings.PROXY_USERNAME.setValue(string);
        ConnectionSettings.PROXY_PASS.setValue(string2);
        ConnectionSettings.PROXY_AUTHENTICATE.setValue(bl);
        COConfigurationManager.setParameter("Proxy.Username", string);
        COConfigurationManager.setParameter("Proxy.Password", string2);
        COConfigurationManager.save();
        return false;
    }

    @Override
    public boolean isDirty() {
        return !ConnectionSettings.PROXY_USERNAME.getValue().equals(this.PROXY_USERNAME_FIELD.getText()) || !ConnectionSettings.PROXY_PASS.getValue().equals(this.PROXY_PASSWORD_FIELD.getText()) || ConnectionSettings.PROXY_AUTHENTICATE.getValue() != this.CHECK_BOX.isSelected();
    }

    private void updateState() {
        this.PROXY_USERNAME_FIELD.setEnabled(this.CHECK_BOX.isSelected());
        this.PROXY_PASSWORD_FIELD.setEnabled(this.CHECK_BOX.isSelected());
        this.PROXY_USERNAME_FIELD.setEditable(this.CHECK_BOX.isSelected());
        this.PROXY_PASSWORD_FIELD.setEditable(this.CHECK_BOX.isSelected());
    }

    private class LocalAuthenticateListener
    implements ItemListener {
        private LocalAuthenticateListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ProxyLoginPaneItem.this.updateState();
        }
    }
}

