/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.UpdateManagerSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class ShowPromoOverlaysPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("FrostClick Promotions");
    public static final String LABEL = I18n.tr("You can enable or disable the FrostClick Promotion on the welcome screen. FrostClick promotions help artists and content creators distribute their content legally and freely to hundreds of thousands of people via FrostWire, BitTorrent and Gnutella. Keep this option on to support file sharing and the future of content distribution.");
    private final String SHOW_PROMOTION_OVERLAYS_LABEL = I18nMarker.marktr("Enable FrostClick Promotions (highly recommended):");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public ShowPromoOverlaysPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.SHOW_PROMOTION_OVERLAYS_LABEL, this.CHECK_BOX, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    @Override
    public void initOptions() {
        this.CHECK_BOX.setSelected(UpdateManagerSettings.SHOW_PROMOTION_OVERLAYS.getValue());
    }

    @Override
    public boolean applyOptions() throws IOException {
        UpdateManagerSettings.SHOW_PROMOTION_OVERLAYS.setValue(this.CHECK_BOX.isSelected());
        return false;
    }

    @Override
    public boolean isDirty() {
        return UpdateManagerSettings.SHOW_PROMOTION_OVERLAYS.getValue() != this.CHECK_BOX.isSelected();
    }
}

