/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.OSUtils;

public class ShutdownPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Shutdown Behavior");
    public static final String LABEL = I18n.tr("You can choose the default shutdown behavior.");
    private JRadioButton shutdownImmediately;
    private JRadioButton minimizeToTray;
    private JCheckBox _checkBoxShowHideExitDialog;

    public ShutdownPaneItem() {
        super(TITLE, LABEL);
        BoxPanel boxPanel = new BoxPanel();
        String string = I18nMarker.marktr("Shutdown Immediately");
        String string2 = I18nMarker.marktr("Minimize to System Tray");
        this.shutdownImmediately = new JRadioButton(I18n.tr(string));
        this.minimizeToTray = new JRadioButton(I18n.tr(string2));
        String string3 = I18nMarker.marktr("Show dialog to ask before close");
        this._checkBoxShowHideExitDialog = new JCheckBox(string3);
        ButtonGroup buttonGroup = new ButtonGroup();
        boxPanel.add(this.shutdownImmediately);
        buttonGroup.add(this.shutdownImmediately);
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
            boxPanel.add(this.minimizeToTray);
            buttonGroup.add(this.minimizeToTray);
        }
        BoxPanel boxPanel2 = new BoxPanel(0);
        boxPanel2.add(boxPanel);
        boxPanel2.add(Box.createHorizontalGlue());
        boxPanel2.add(this._checkBoxShowHideExitDialog);
        boxPanel2.add(Box.createHorizontalGlue());
        this.add(boxPanel2);
    }

    @Override
    public boolean applyOptions() throws IOException {
        if (this.minimizeToTray.isSelected()) {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(true);
        } else {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(false);
        }
        ApplicationSettings.SHOW_HIDE_EXIT_DIALOG.setValue(this._checkBoxShowHideExitDialog.isSelected());
        return false;
    }

    @Override
    public void initOptions() {
        if (ApplicationSettings.MINIMIZE_TO_TRAY.getValue()) {
            if (!OSUtils.supportsTray() || ResourceManager.instance().isTrayIconAvailable()) {
                this.minimizeToTray.setSelected(true);
            }
        } else {
            this.shutdownImmediately.setSelected(true);
        }
        this._checkBoxShowHideExitDialog.setSelected(ApplicationSettings.SHOW_HIDE_EXIT_DIALOG.getValue());
    }

    @Override
    public boolean isDirty() {
        boolean bl = ApplicationSettings.MINIMIZE_TO_TRAY.getValue();
        boolean bl2 = bl && ResourceManager.instance().isTrayIconAvailable();
        boolean bl3 = !ApplicationSettings.MINIMIZE_TO_TRAY.getValue();
        return this.minimizeToTray.isSelected() != bl2 || this.shutdownImmediately.isSelected() != bl3 || this._checkBoxShowHideExitDialog.isSelected() != ApplicationSettings.SHOW_HIDE_EXIT_DIALOG.getValue();
    }
}

