/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.search.LocalSearchEngine;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public final class SmartSearchDBPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Smart Search");
    public static final String LABEL = I18n.tr("The Smart Search database is used to speed up individual file searches, it's how FrostWire remembers information about .torrent contents.");
    private JLabel _numTorrentsLabel;
    private JLabel _numFilesLabel;
    private long _numTorrents = 0L;
    private long _numFiles = 0L;

    public SmartSearchDBPaneItem() {
        super(TITLE, LABEL);
        Font font = new Font("dialog", 1, 12);
        this._numTorrentsLabel = new JLabel();
        this._numFilesLabel = new JLabel();
        this._numTorrentsLabel.setFont(font);
        this._numFilesLabel.setFont(font);
        LabeledComponent labeledComponent = new LabeledComponent(I18n.tr("Total torrents indexed"), this._numTorrentsLabel);
        LabeledComponent labeledComponent2 = new LabeledComponent(I18n.tr("Total files indexed"), this._numFilesLabel);
        this.add(this.getVerticalSeparator());
        JButton jButton = new JButton("Reset Smart Search Database");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.safeInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SmartSearchDBPaneItem.this.resetSmartSearchDB();
                        SmartSearchDBPaneItem.this.initOptions();
                    }
                });
            }
        });
        this.add(labeledComponent.getComponent());
        this.add(labeledComponent2.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(jButton);
    }

    protected void resetSmartSearchDB() {
        int n = JOptionPane.showConfirmDialog(GUIMediator.getAppFrame(), I18n.tr("If you continue you will erase all the information related to\n" + this._numTorrents + " torrents and " + this._numFiles + " files that FrostWire has learned to speed up your search results.\nDo you wish to continue?"), I18n.tr("Are you sure?"), 0, 3);
        if (n == 0) {
            LocalSearchEngine.instance().resetDB();
        }
    }

    @Override
    public void initOptions() {
        this._numTorrents = LocalSearchEngine.instance().getTotalTorrents();
        this._numTorrentsLabel.setText(String.valueOf(this._numTorrents));
        this._numFiles = LocalSearchEngine.instance().getTotalFiles();
        this._numFilesLabel.setText(String.valueOf(this._numFiles));
    }

    @Override
    public boolean applyOptions() throws IOException {
        return true;
    }

    @Override
    public boolean isDirty() {
        return false;
    }
}

