/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StoreSaveTemplateProcessor {
    public static final String ARTIST_LABEL = "artist";
    public static final String ALBUM_LABEL = "album";
    public static final String HOME_LABEL = "home";
    static final String TEMPLATE_PROCESSOR_MISSING_DELIMETER = "STORE_TEMPLATE_PROCESSOR_MISSING_DELIMETER";
    static final String TEMPLATE_PROCESSOR_UNKNOWN_REPLACEMENT = "STORE_TEMPLATE_PROCESSOR_UNKNOWN_REPLACEMENT";
    static final String TEMPLATE_PROCESSOR_UNCLOSED_VARIABLE = "STORE_TEMPLATE_PROCESSOR_UNCLOSED_VARIABLE";
    private static final List<Character> END_DELIMS = new ArrayList<Character>();

    public boolean isValid(String string) throws IllegalTemplateException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ARTIST_LABEL, "");
        hashMap.put(ALBUM_LABEL, "");
        hashMap.put(HOME_LABEL, "");
        this.getOutputDirectory(string, hashMap, new File("."));
        return true;
    }

    public File getOutputDirectory(String string, Map<String, String> map, File file) throws IllegalTemplateException {
        if (string == null) {
            return file;
        }
        if (string.equals("")) {
            return file;
        }
        if (string.equals(".")) {
            return file;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (n) {
                case 0: {
                    if (c == '$') {
                        n = 1;
                        continue block5;
                    }
                    stringBuffer.append(c);
                    continue block5;
                }
                case 1: {
                    if (this.isDelim(c)) {
                        n = 2;
                        stringBuffer2 = new StringBuffer();
                        continue block5;
                    }
                    if (Character.isWhitespace(c)) continue block5;
                    throw new IllegalTemplateException(i, TEMPLATE_PROCESSOR_MISSING_DELIMETER, string);
                }
                case 2: {
                    if (this.isDelim(c)) {
                        String string2 = stringBuffer2.toString().replaceAll("\\s", "");
                        String string3 = map.get(string2);
                        if (string3 == null) {
                            throw new IllegalTemplateException(i, TEMPLATE_PROCESSOR_UNKNOWN_REPLACEMENT, string);
                        }
                        stringBuffer.append(string3);
                        n = 0;
                        continue block5;
                    }
                    stringBuffer2.append(c);
                }
            }
        }
        if (n == 2) {
            throw new IllegalTemplateException(string.length(), TEMPLATE_PROCESSOR_UNCLOSED_VARIABLE, string);
        }
        return new File(file, stringBuffer.toString());
    }

    private boolean isDelim(char c) {
        for (Character c2 : END_DELIMS) {
            if (c2.charValue() != c) continue;
            return true;
        }
        return false;
    }

    static {
        END_DELIMS.add(Character.valueOf('{'));
        END_DELIMS.add(Character.valueOf('}'));
        END_DELIMS.add(Character.valueOf('('));
        END_DELIMS.add(Character.valueOf(')'));
        END_DELIMS.add(Character.valueOf('['));
        END_DELIMS.add(Character.valueOf(']'));
    }

    public static final class IllegalTemplateException
    extends ParseException {
        private static final long serialVersionUID = -3544104037008917572L;
        private final String template;

        public IllegalTemplateException(int n, String string, String string2) {
            super(string, n);
            this.template = string2;
        }

        @Override
        public String getMessage() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = null;
            try {
                string = I18n.tr(super.getMessage());
            }
            catch (Exception exception) {
                string = exception.getLocalizedMessage();
            }
            stringBuilder.append(string);
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(this.template);
            stringBuilder.append(System.getProperty("line.separator"));
            int n = this.getErrorOffset();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('^');
            return stringBuilder.toString();
        }
    }

    private static interface States {
        public static final int LOOKING_FOR_DOLLAR = 0;
        public static final int HAVE_DOLLAR = 1;
        public static final int INSIDE_DELIMS = 2;
    }
}

