/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.BittorrentSettings;
import java.io.IOException;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.limewire.i18n.I18nMarker;

public class TorrentConnectionPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("BitTorrent Connection Settings");
    public static final String TEXT = I18n.tr("Adjust connection settings to make better use of your internet connection");
    public static final String MAX_ACTIVE_DOWNLOADS = I18n.tr("Maximum active downloads");
    public static final String MAX_GLOBAL_NUM_CONNECTIONS = I18n.tr("Global maximum number of connections");
    public static final String MAX_PEERS_PER_TORRENT = I18n.tr("Maximum number of connected peers per torrent");
    public static final String MAX_UPLOAD_SLOTS = I18n.tr("Number of upload slots per torrent");
    private WholeNumberField MAX_ACTIVE_DOWNLOADS_FIELD = new SizedWholeNumberField(4);
    private WholeNumberField MAX_GLOBAL_NUM_CONNECTIONS_FIELD = new SizedWholeNumberField(4);
    private WholeNumberField MAX_PEERS_PER_TORRENT_FIELD = new SizedWholeNumberField(4);
    private WholeNumberField MAX_UPLOAD_SLOTS_FIELD = new SizedWholeNumberField(4);

    public TorrentConnectionPaneItem() {
        super(TITLE, TEXT);
        BoxPanel boxPanel = new BoxPanel();
        LabeledComponent labeledComponent = new LabeledComponent(I18nMarker.marktr(MAX_ACTIVE_DOWNLOADS), this.MAX_ACTIVE_DOWNLOADS_FIELD, 120, 10);
        boxPanel.add(labeledComponent.getComponent());
        boxPanel.addVerticalComponentGap();
        labeledComponent = new LabeledComponent(I18nMarker.marktr(MAX_GLOBAL_NUM_CONNECTIONS), this.MAX_GLOBAL_NUM_CONNECTIONS_FIELD, 120, 10);
        boxPanel.add(labeledComponent.getComponent());
        boxPanel.addVerticalComponentGap();
        labeledComponent = new LabeledComponent(I18nMarker.marktr(MAX_PEERS_PER_TORRENT), this.MAX_PEERS_PER_TORRENT_FIELD, 120, 10);
        boxPanel.add(labeledComponent.getComponent());
        boxPanel.addVerticalComponentGap();
        labeledComponent = new LabeledComponent(I18nMarker.marktr(MAX_UPLOAD_SLOTS), this.MAX_UPLOAD_SLOTS_FIELD, 120, 10);
        boxPanel.add(labeledComponent.getComponent());
        boxPanel.addVerticalComponentGap();
        this.add(boxPanel);
    }

    @Override
    public boolean isDirty() {
        return BittorrentSettings.TORRENT_MAX_ACTIVE_DOWNLOADS.getValue() != this.MAX_ACTIVE_DOWNLOADS_FIELD.getValue() || COConfigurationManager.getIntParameter("Max.Peer.Connections.Total") != this.MAX_GLOBAL_NUM_CONNECTIONS_FIELD.getValue() || COConfigurationManager.getIntParameter("Max.Peer.Connections.Per.Torrent") != this.MAX_PEERS_PER_TORRENT_FIELD.getValue() || COConfigurationManager.getIntParameter("Max Uploads") != this.MAX_UPLOAD_SLOTS_FIELD.getValue();
    }

    @Override
    public void initOptions() {
        ConfigurationManager.getInstance().load();
        this.MAX_ACTIVE_DOWNLOADS_FIELD.setValue(BittorrentSettings.TORRENT_MAX_ACTIVE_DOWNLOADS.getValue());
        this.MAX_GLOBAL_NUM_CONNECTIONS_FIELD.setValue(COConfigurationManager.getIntParameter("Max.Peer.Connections.Total"));
        this.MAX_PEERS_PER_TORRENT_FIELD.setValue(COConfigurationManager.getIntParameter("Max.Peer.Connections.Per.Torrent"));
        this.MAX_UPLOAD_SLOTS_FIELD.setValue(COConfigurationManager.getIntParameter("Max Uploads"));
    }

    @Override
    public boolean applyOptions() throws IOException {
        BittorrentSettings.TORRENT_MAX_ACTIVE_DOWNLOADS.setValue(this.MAX_ACTIVE_DOWNLOADS_FIELD.getValue());
        COConfigurationManager.setParameter("Max.Peer.Connections.Total", this.MAX_GLOBAL_NUM_CONNECTIONS_FIELD.getValue());
        COConfigurationManager.setParameter("Max.Peer.Connections.Per.Torrent", this.MAX_PEERS_PER_TORRENT_FIELD.getValue());
        COConfigurationManager.setParameter("Max Uploads", this.MAX_UPLOAD_SLOTS_FIELD.getValue());
        COConfigurationManager.setParameter("Max Uploads Seeding", this.MAX_UPLOAD_SLOTS_FIELD.getValue());
        COConfigurationManager.save();
        return false;
    }
}

