/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.Font;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;

public class TorrentGlobalSpeedPaneItem
extends AbstractPaneItem {
    private static final int MAX_SLIDER_VALUE = 102401;
    public static final String TITLE_DOWNLOAD_SPEED = I18n.tr("BitTorrent Global Tranfer Speeds");
    public static final String DESCRIPTION_DOWNLOAD_SPEED = I18n.tr("Set the Maximum BitTorrent transfer speeds in KB/s.\nTip: Use your keyboard arrows for more precision");
    private final String LABEL_DOWNLOAD_SPEED = I18n.tr("Download Speed:");
    private JSlider DOWNLOAD_SLIDER = new JSlider(1, 102401);
    private final JLabel DOWNLOAD_SLIDER_LABEL = new JLabel();
    private int storedDownloadSpeed;
    private String globalDownloadSpeedConfigKey = "Max Download Speed KBs";
    public static final String DESCRIPTION_UPLOAD_SPEED = I18n.tr("<html>Set the Maximum BitTorrent upload speed in KB/s.<p>Note: Too low upload speeds (leeching) could be penalized by some trackers, resulting in slower downloads.</html>");
    private final String LABEL_UPLOAD_SPEED = I18n.tr("Upload Speed:");
    private JSlider UPLOAD_SLIDER = new JSlider(1, 102401);
    private final JLabel UPLOAD_SLIDER_LABEL = new JLabel();
    private int storedUploadSpeed;
    private String globalUploadSpeedConfigKey = "Max Upload Speed KBs";

    public TorrentGlobalSpeedPaneItem() {
        super(TITLE_DOWNLOAD_SPEED, DESCRIPTION_DOWNLOAD_SPEED);
        this.DOWNLOAD_SLIDER.setMajorTickSpacing(1024);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        JLabel jLabel = new JLabel(I18n.tr("Min speed"));
        JLabel jLabel2 = new JLabel(I18n.tr("Max speed"));
        Font font = new Font("Helvetica", 1, 10);
        jLabel.setFont(font);
        jLabel2.setFont(font);
        hashtable.put(1, jLabel);
        hashtable.put(103424, jLabel2);
        this.DOWNLOAD_SLIDER.setLabelTable(hashtable);
        this.DOWNLOAD_SLIDER.setPaintLabels(true);
        this.DOWNLOAD_SLIDER.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TorrentGlobalSpeedPaneItem.this.updateSpeedLabel(TorrentGlobalSpeedPaneItem.this.DOWNLOAD_SLIDER, TorrentGlobalSpeedPaneItem.this.DOWNLOAD_SLIDER_LABEL);
            }
        });
        LabeledComponent labeledComponent = new LabeledComponent(this.LABEL_DOWNLOAD_SPEED, this.DOWNLOAD_SLIDER_LABEL, 120, 10);
        this.add(this.DOWNLOAD_SLIDER);
        this.add(this.getVerticalSeparator());
        this.add(labeledComponent.getComponent());
        this.UPLOAD_SLIDER.setMajorTickSpacing(1024);
        Hashtable<Integer, JLabel> hashtable2 = new Hashtable<Integer, JLabel>();
        JLabel jLabel3 = new JLabel(I18n.tr("Min speed"));
        JLabel jLabel4 = new JLabel(I18n.tr("Max speed"));
        jLabel3.setFont(font);
        jLabel4.setFont(font);
        hashtable2.put(1, jLabel3);
        hashtable2.put(103424, jLabel4);
        this.UPLOAD_SLIDER.setLabelTable(hashtable2);
        this.UPLOAD_SLIDER.setPaintLabels(true);
        this.UPLOAD_SLIDER.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TorrentGlobalSpeedPaneItem.this.updateSpeedLabel(TorrentGlobalSpeedPaneItem.this.UPLOAD_SLIDER, TorrentGlobalSpeedPaneItem.this.UPLOAD_SLIDER_LABEL);
            }
        });
        LabeledComponent labeledComponent2 = new LabeledComponent(this.LABEL_UPLOAD_SPEED, this.UPLOAD_SLIDER_LABEL, 120, 10);
        JLabel jLabel5 = new JLabel(DESCRIPTION_UPLOAD_SPEED);
        this.add(jLabel5);
        this.add(this.UPLOAD_SLIDER);
        this.add(this.getVerticalSeparator());
        this.add(labeledComponent2.getComponent());
    }

    private void updateSpeedLabel(JSlider jSlider, JLabel jLabel) {
        float f = jSlider.getValue();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        String string = String.valueOf(numberFormat.format(f)) + " KB/s";
        if (f > 102400.0f) {
            jLabel.setText(I18n.tr("Unlimited"));
        } else {
            jLabel.setText(string);
        }
    }

    @Override
    public void initOptions() {
        this.storedDownloadSpeed = COConfigurationManager.getIntParameter(this.globalDownloadSpeedConfigKey);
        if (this.storedDownloadSpeed == 0) {
            this.DOWNLOAD_SLIDER.setValue(103424);
            this.DOWNLOAD_SLIDER_LABEL.setText(I18n.tr("Unlimited"));
        } else {
            this.DOWNLOAD_SLIDER.setValue(this.storedDownloadSpeed);
        }
        this.updateSpeedLabel(this.DOWNLOAD_SLIDER, this.DOWNLOAD_SLIDER_LABEL);
        this.storedUploadSpeed = COConfigurationManager.getIntParameter(this.globalUploadSpeedConfigKey);
        if (this.storedUploadSpeed == 0) {
            this.UPLOAD_SLIDER.setValue(103424);
            this.UPLOAD_SLIDER_LABEL.setText(I18n.tr("Unlimited"));
        } else {
            this.UPLOAD_SLIDER.setValue(this.storedUploadSpeed);
        }
        this.updateSpeedLabel(this.UPLOAD_SLIDER, this.UPLOAD_SLIDER_LABEL);
    }

    @Override
    public boolean applyOptions() throws IOException {
        int n = this.UPLOAD_SLIDER.getValue();
        int n2 = this.DOWNLOAD_SLIDER.getValue();
        if (n == 102401) {
            n = 0;
        }
        if (n2 == 102401) {
            n2 = 0;
        }
        COConfigurationManager.setParameter(this.globalDownloadSpeedConfigKey, n2);
        COConfigurationManager.setParameter(this.globalUploadSpeedConfigKey, n);
        this.DOWNLOAD_SLIDER.setValue(n2 == 0 ? 102401 : n2);
        this.UPLOAD_SLIDER.setValue(n == 0 ? 102401 : n);
        COConfigurationManager.save();
        this.updateSpeedLabel(this.UPLOAD_SLIDER, this.UPLOAD_SLIDER_LABEL);
        this.updateSpeedLabel(this.DOWNLOAD_SLIDER, this.DOWNLOAD_SLIDER_LABEL);
        return false;
    }

    @Override
    public boolean isDirty() {
        return false;
    }
}

