/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.settings.SearchSettings;

public abstract class AbstractSearchResult
implements SearchResult {
    private String query;

    public AbstractSearchResult(String string) {
        this.query = string;
    }

    @Override
    public String getExtension() {
        String string = this.getFileName();
        if (string == null) {
            throw new NullPointerException("getFileName() can't return a null result");
        }
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    @Override
    public void showDetails(boolean bl) {
        if (bl) {
            GUIMediator.openURL(this.getWebSearchResult().getDetailsUrl());
        } else if (SearchSettings.SHOW_DETAIL_PAGE_AFTER_DOWNLOAD_START.getValue()) {
            GUIMediator.openURL(this.getWebSearchResult().getDetailsUrl(), 8000L);
        }
    }

    @Override
    public boolean allowDeepSearch() {
        return false;
    }

    @Override
    public String getQuery() {
        return this.query;
    }
}

