/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.filters.TableLineFilter;
import com.limegroup.gnutella.gui.search.AllowFilter;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import java.util.ArrayList;
import java.util.List;

class CompositeFilter
implements TableLineFilter<SearchResultDataLine> {
    private List<TableLineFilter<SearchResultDataLine>> delegates;

    CompositeFilter(int n) {
        this.delegates = new ArrayList<TableLineFilter<SearchResultDataLine>>(n);
        for (int i = 0; i < n; ++i) {
            this.delegates.add(null);
        }
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.delegates.size(); ++i) {
            this.delegates.set(i, AllowFilter.instance());
        }
    }

    @Override
    public boolean allow(SearchResultDataLine searchResultDataLine) {
        for (int i = 0; i < this.delegates.size(); ++i) {
            if (this.delegates.get(i).allow(searchResultDataLine)) continue;
            return false;
        }
        return true;
    }

    boolean setFilter(int n, TableLineFilter<SearchResultDataLine> tableLineFilter) {
        if (tableLineFilter == this) {
            throw new IllegalArgumentException("Filter must not be composed of itself");
        }
        if (this.delegates.get(n).equals(tableLineFilter)) {
            return false;
        }
        this.delegates.set(n, tableLineFilter);
        return true;
    }
}

