/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.AbstractSearchResult;
import com.limegroup.gnutella.gui.search.BittorrentSearchResult;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.util.PopupUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JPopupMenu;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;

public class DeepSearchResult
extends AbstractSearchResult
implements BittorrentSearchResult {
    private WebSearchResult _item;
    private SearchEngine _searchEngine;
    private TOTorrentFile _torrentFile;

    public DeepSearchResult(TOTorrentFile tOTorrentFile, WebSearchResult webSearchResult, SearchEngine searchEngine, String string) {
        super(string);
        this._item = webSearchResult;
        this._searchEngine = searchEngine;
        this._torrentFile = tOTorrentFile;
    }

    @Override
    public long getCreationTime() {
        return this._item.getCreationTime();
    }

    @Override
    public String getExtension() {
        return this._torrentFile.getRelativePath().substring(this._torrentFile.getRelativePath().lastIndexOf(".") + 1);
    }

    @Override
    public String getFileName() {
        String string = new File(this._torrentFile.getRelativePath()).getName();
        if (string.startsWith("/")) {
            return string.substring(1);
        }
        return string;
    }

    @Override
    public String getDisplayName() {
        if (this._torrentFile.getRelativePath().indexOf("/") != -1) {
            String string = this._torrentFile.getRelativePath().substring(this._torrentFile.getRelativePath().lastIndexOf("/"));
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            return string.substring(0, string.lastIndexOf("."));
        }
        return this._torrentFile.getRelativePath().substring(0, this._torrentFile.getRelativePath().lastIndexOf("."));
    }

    @Override
    public int getQuality() {
        return 0;
    }

    @Override
    public String getHash() {
        return this._item.getHash();
    }

    @Override
    public String getTorrentURI() {
        return this._item.getTorrentURI();
    }

    @Override
    public long getSize() {
        return this._torrentFile.getLength();
    }

    @Override
    public int getSpeed() {
        return 0x7FFFFFFD;
    }

    @Override
    public String getSource() {
        return this._item.getSource();
    }

    @Override
    public boolean isMeasuredSpeed() {
        return false;
    }

    @Override
    public void download(boolean bl) {
        GUIMediator.instance().openTorrentSearchResult(this._item, this._torrentFile.getRelativePath());
        this.showDetails(false);
    }

    @Override
    public JPopupMenu createMenu(JPopupMenu jPopupMenu, SearchResultDataLine[] searchResultDataLineArray, SearchResultMediator searchResultMediator) {
        PopupUtils.addMenuItem(SearchMediator.DOWNLOAD_STRING, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeepSearchResult.this.download(false);
            }
        }, jPopupMenu, searchResultDataLineArray.length > 0, 1);
        PopupUtils.addMenuItem(SearchMediator.TORRENT_DETAILS_STRING, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeepSearchResult.this.showDetails(true);
            }
        }, jPopupMenu, searchResultDataLineArray.length == 1, 2);
        return jPopupMenu;
    }

    @Override
    public int getSeeds() {
        return this._item.getSeeds();
    }

    @Override
    public SearchEngine getSearchEngine() {
        return this._searchEngine;
    }

    @Override
    public WebSearchResult getWebSearchResult() {
        return this._item;
    }
}

