/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import java.awt.Color;
import java.awt.Graphics;

public final class Ditherer {
    private final int _redT;
    private final int _greenT;
    private final int _blueT;
    private final int _redB;
    private final int _greenB;
    private final int _blueB;
    private int STEPS;
    private boolean fixedSteps;
    private final Color from;
    private final Color to;
    private Shader shader;
    private int orientation;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;

    public Ditherer(int n, Color color, Color color2) {
        this(color, color2, 1, new LinearShader(), n);
        if (n <= 0) {
            throw new IllegalArgumentException("steps must be greater than zero");
        }
    }

    public Ditherer(Color color, Color color2, int n, Shader shader) {
        this(color, color2, n, shader, 0);
    }

    private Ditherer(Color color, Color color2, int n, Shader shader, int n2) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("not a valid orientation");
        }
        if (n2 > 0) {
            this.STEPS = n2;
            this.fixedSteps = true;
        }
        this._redT = color.getRed();
        this._greenT = color.getGreen();
        this._blueT = color.getBlue();
        this._redB = color2.getRed();
        this._greenB = color2.getGreen();
        this._blueB = color2.getBlue();
        this.from = color;
        this.to = color2;
        this.shader = shader;
        this.orientation = n;
    }

    public Color getFromColor() {
        return this.from;
    }

    public Color getToColor() {
        return this.to;
    }

    public void draw(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.orientation == 0) {
            n5 = n2;
            n4 = n;
        } else {
            n5 = n;
            n4 = n2;
        }
        if (this.fixedSteps) {
            n3 = n5 / this.STEPS;
        } else {
            n3 = 2;
            this.STEPS = n5 / n3;
        }
        float f = this._redT;
        float f2 = this._greenT;
        float f3 = this._blueT;
        int n6 = 0;
        for (int i = 0; i < this.STEPS; ++i) {
            Color color = new Color(Ditherer.round(f), Ditherer.round(f2), Ditherer.round(f3));
            graphics.setColor(color);
            this.drawRect(graphics, n6, n4, n3);
            n6 += n3;
            float f4 = this.shader.getValue((float)i / (float)this.STEPS);
            f = (float)this._redT + (float)(this._redB - this._redT) * f4;
            f2 = (float)this._greenT + (float)(this._greenB - this._greenT) * f4;
            f3 = (float)this._blueT + (float)(this._blueB - this._blueT) * f4;
        }
        Color color = new Color(Ditherer.round(f), Ditherer.round(f2), Ditherer.round(f3));
        graphics.setColor(color);
        this.drawRect(graphics, n6, n4, n5 - n6);
    }

    private void drawRect(Graphics graphics, int n, int n2, int n3) {
        if (this.orientation == 1) {
            graphics.fillRect(0, n, n2, n3);
        } else {
            graphics.fillRect(n, 0, n3, n2);
        }
    }

    private static int round(float f) {
        int n = Math.round(f);
        if (n < 0) {
            return 0;
        }
        if (n > 255) {
            return 255;
        }
        return n;
    }

    public static class PolygonShader
    implements Shader {
        private float exponent;

        public PolygonShader(float f) {
            this.exponent = f;
        }

        @Override
        public float getValue(float f) {
            return (float)Math.pow(f, this.exponent);
        }
    }

    public static class LinearShader
    implements Shader {
        @Override
        public float getValue(float f) {
            return f;
        }
    }

    public static interface Shader {
        public float getValue(float var1);
    }
}

