/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.components.LabeledRangeSlider;
import com.frostwire.gui.filters.TableLineFilter;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.LabeledTextField;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;

public class GeneralResultFilter
implements TableLineFilter<SearchResultDataLine> {
    private SearchResultMediator _rp;
    private LabeledRangeSlider _rangeSliderSeeds;
    private LabeledRangeSlider _rangeSliderSize;
    private int _minResultsSeeds;
    private int _maxResultsSeeds;
    private long _minResultsSize;
    private long _maxResultsSize;
    private int _minSeeds;
    private int _maxSeeds;
    private int _minSize;
    private int _maxSize;
    private String _keywords;

    public GeneralResultFilter(SearchResultMediator searchResultMediator, LabeledRangeSlider labeledRangeSlider, LabeledRangeSlider labeledRangeSlider2, LabeledTextField labeledTextField) {
        this._rp = searchResultMediator;
        this._rangeSliderSeeds = labeledRangeSlider;
        this._rangeSliderSize = labeledRangeSlider2;
        this._minResultsSeeds = Integer.MAX_VALUE;
        this._maxResultsSeeds = 0;
        this._minResultsSize = Long.MAX_VALUE;
        this._maxResultsSize = 0L;
        this._minSeeds = 0;
        this._maxSeeds = Integer.MAX_VALUE;
        this._minSize = 0;
        this._maxSize = Integer.MAX_VALUE;
    }

    @Override
    public boolean allow(SearchResultDataLine searchResultDataLine) {
        int n;
        boolean bl = false;
        int n2 = searchResultDataLine.getSeeds();
        if (n2 < this._minResultsSeeds) {
            this._minResultsSeeds = n2;
            bl = true;
        }
        if (n2 > this._maxResultsSeeds) {
            this._maxResultsSeeds = n2;
            bl = true;
        }
        boolean bl2 = false;
        long l = searchResultDataLine.getSize();
        if (l < this._minResultsSize) {
            this._minResultsSize = l;
            bl2 = true;
        }
        if (l > this._maxResultsSize) {
            this._maxResultsSize = l;
            bl2 = true;
        }
        if (bl) {
            this._rangeSliderSeeds.getMinimumValueLabel().setText(String.valueOf(this._minResultsSeeds));
            this._rangeSliderSeeds.getMaximumValueLabel().setText(String.valueOf(this._maxResultsSeeds));
        }
        if (bl2) {
            this._rangeSliderSize.getMinimumValueLabel().setText(GUIUtils.toUnitbytes(this._minResultsSize));
            this._rangeSliderSize.getMaximumValueLabel().setText(GUIUtils.toUnitbytes(this._maxResultsSize));
        }
        boolean bl3 = false;
        if (this._maxResultsSeeds > this._minResultsSeeds) {
            n = (n2 - this._minResultsSeeds) * 1000 / (this._maxResultsSeeds - this._minResultsSeeds);
            bl3 = this._minSeeds == 0 && this._maxSeeds == 1000 ? true : (this._minSeeds == 0 ? n <= this._maxSeeds : (this._maxSeeds == 1000 ? n >= this._minSeeds : n >= this._minSeeds && n <= this._maxSeeds));
        } else {
            bl3 = n2 == this._maxResultsSeeds;
        }
        n = 0;
        if (this._maxResultsSize > this._minResultsSize) {
            long l2 = (l - this._minResultsSize) * 1000L / (this._maxResultsSize - this._minResultsSize);
            n = this._minSize == 0 && this._maxSize == 1000 ? 1 : (this._minSize == 0 ? (l2 <= (long)this._maxSize ? 1 : 0) : (this._maxSize == 1000 ? (l2 >= (long)this._minSize ? 1 : 0) : (l2 >= (long)this._minSize && l2 <= (long)this._maxSize ? 1 : 0)));
        } else {
            n = l == this._maxResultsSize ? 1 : 0;
        }
        boolean bl4 = this.hasKeywords(searchResultDataLine.getDisplayName());
        return bl3 && n != 0 && bl4;
    }

    private boolean hasKeywords(String string) {
        String string2 = this._keywords;
        if (string2 == null || string2.trim().length() == 0) {
            return true;
        }
        String[] stringArray = string2.split(" ");
        if (stringArray.length == 1) {
            return string.toLowerCase().contains(string2.toLowerCase());
        }
        String string3 = string.toLowerCase();
        for (String string4 : stringArray) {
            if (string3.contains(string4.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    public int getMinResultsSeeds() {
        return this._minResultsSeeds;
    }

    public int getMaxResultsSeeds() {
        return this._maxResultsSeeds;
    }

    public long getMinResultsSize() {
        return this._minResultsSize;
    }

    public long getMaxResultsSize() {
        return this._maxResultsSize;
    }

    public int getMinSeeds() {
        return this._minSeeds;
    }

    public int getMaxSeeds() {
        return this._maxSeeds;
    }

    public int getMinSize() {
        return this._minSize;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public void setRangeSeeds(int n, int n2) {
        this._minSeeds = n;
        this._maxSeeds = n2;
        this._rp.filterChanged(this, 1);
    }

    public void setRangeSize(int n, int n2) {
        this._minSize = n;
        this._maxSize = n2;
        this._rp.filterChanged(this, 1);
    }

    public void updateKeywordFiltering(String string) {
        this._keywords = new String(string);
        this._rp.filterChanged(this, 1);
    }

    public String getKeywordFilterText() {
        return this._keywords;
    }
}

