/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.JsonEngine;
import com.frostwire.alexandria.LibraryUtils;
import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.gui.filters.SearchFilter;
import com.frostwire.websearch.youtube.YouTubeEntry;
import com.frostwire.websearch.youtube.YouTubeEntryLink;
import com.frostwire.websearch.youtube.YouTubeSearchResult;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.DeepSearchResult;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchEngineSearchResult;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.search.SmartSearchResult;
import com.limegroup.gnutella.gui.search.YouTubePackageItemSearchResult;
import com.limegroup.gnutella.gui.search.YouTubePackageSearchResult;
import com.limegroup.gnutella.gui.search.db.SmartSearchDB;
import com.limegroup.gnutella.gui.search.db.TorrentDBPojo;
import com.limegroup.gnutella.gui.search.db.TorrentFileDBPojo;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.controlling.linkcrawler.PackageInfo;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.h2.fulltext.FullTextLucene2;
import org.jdownloader.controlling.filter.LinkFilterController;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.StringUtils;

public class LocalSearchEngine {
    private static final Log LOG = LogFactory.getLog(LocalSearchEngine.class);
    private static final ExecutorService DOWNLOAD_TORRENTS_EXECUTOR = ExecutorsHelper.newFixedSizePriorityThreadPool(10, "DownloadTorrentsExecutor");
    private static final ExecutorService CRAWL_YOUTUBE_LINKS_EXECUTOR = ExecutorsHelper.newFixedSizePriorityThreadPool(2, "CRAWL_YOUTUBE_LINKS_EXECUTOR");
    private static final int MAX_TORRENT_DOWNLOADS = 10;
    private static final ExecutorService INDEX_TORRENTS_EXECUTOR = ExecutorsHelper.newFixedSizeThreadPool(1, "IndexTorrentsExecutor");
    private final int DEEP_SEARCH_DELAY;
    private final int MAXIMUM_TORRENTS_TO_SCAN;
    private final int DEEP_SEARCH_ROUNDS;
    private final int LOCAL_SEARCH_RESULTS_LIMIT;
    private static LocalSearchEngine INSTANCE;
    private static final Comparator<SearchResultDataLine> TORRENT_SEED_TABLELINE_COMPARATOR;
    private HashSet<String> KNOWN_INFO_HASHES = new HashSet();
    private SmartSearchDB DB;
    private JsonEngine JSON_ENGINE;
    private Queue<IndexTorrentElement> INDEX_TORRENT_QUEUE = new LinkedList<IndexTorrentElement>();
    public static final HashSet<String> IGNORABLE_KEYWORDS;

    public LocalSearchEngine() {
        this.DEEP_SEARCH_DELAY = SearchSettings.SMART_SEARCH_START_DELAY.getValue();
        this.MAXIMUM_TORRENTS_TO_SCAN = SearchSettings.SMART_SEARCH_MAXIMUM_TORRENTS_TO_SCAN.getValue();
        this.DEEP_SEARCH_ROUNDS = SearchSettings.SMART_SEARCH_DEEP_SEARCH_ROUNDS.getValue();
        this.LOCAL_SEARCH_RESULTS_LIMIT = SearchSettings.SMART_SEARCH_FULLTEXT_SEARCH_RESULTS_LIMIT.getValue();
        this.DB = new SmartSearchDB(SearchSettings.SMART_SEARCH_DATABASE_FOLDER.getValue());
        this.JSON_ENGINE = new JsonEngine();
    }

    public static LocalSearchEngine instance() {
        if (INSTANCE == null) {
            INSTANCE = new LocalSearchEngine();
        }
        return INSTANCE;
    }

    private static final String stringSanitize(String string) {
        string = LocalSearchEngine.stripHtml(string);
        string = string.replaceAll("\\.torrent|www\\.|\\.com|[\\\\\\/%_;\\-\\.\\(\\)\\[\\]\\n\\r\u2013]", " ");
        return StringUtils.removeDoubleSpaces(string);
    }

    private static String stripHtml(String string) {
        string = string.replaceAll("\\<.*?>", "");
        string = string.replaceAll("\\&.*?\\;", "");
        return string;
    }

    public List<SmartSearchResult> search(String string) {
        string = LibraryUtils.fuzzyLuceneQuery(string);
        String string2 = "SELECT * FROM FTL_SEARCH(?, ?, 0)";
        List<List<Object>> list = this.DB.query(string2, string, this.LOCAL_SEARCH_RESULTS_LIMIT);
        int n = " PUBLIC   FILES  WHERE  FILEID =".length();
        StringBuilder stringBuilder = new StringBuilder("(");
        int n2 = list.size();
        int n3 = 0;
        for (List<Object> list2 : list) {
            String string3 = (String)list2.get(0);
            stringBuilder.append(string3.substring(n));
            if (n3++ >= n2 - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        String string4 = "SELECT Torrents.json, Files.json, torrentName, fileName FROM Torrents JOIN Files ON Torrents.torrentId = Files.torrentId WHERE Files.fileId IN " + stringBuilder.toString() + " ORDER BY seeds DESC LIMIT " + this.LOCAL_SEARCH_RESULTS_LIMIT;
        long l = System.currentTimeMillis();
        List<List<Object>> list3 = this.DB.query(string4, new Object[0]);
        long l2 = System.currentTimeMillis() - l;
        System.out.print("Found " + list3.size() + " local results in " + l2 + "ms. ");
        if (l2 > 3000L) {
            System.out.println("\nWarning: Results took too long, there's something wrong with the database, you might want to delete your 'search_db' folder inside the FrostWire preferences folder.");
        }
        ArrayList<SmartSearchResult> arrayList = new ArrayList<SmartSearchResult>();
        Map<Integer, SearchEngine> map = SearchEngine.getSearchEngineMap();
        String string5 = null;
        for (List<Object> list4 : list3) {
            try {
                string5 = (String)list4.get(0);
                String string6 = (String)list4.get(1);
                TorrentDBPojo torrentDBPojo = this.JSON_ENGINE.toObject(string5, TorrentDBPojo.class);
                if (!map.get(torrentDBPojo.searchEngineID).isEnabled()) continue;
                TorrentFileDBPojo torrentFileDBPojo = this.JSON_ENGINE.toObject(string6, TorrentFileDBPojo.class);
                arrayList.add(new SmartSearchResult(torrentDBPojo, torrentFileDBPojo, string));
                this.KNOWN_INFO_HASHES.add(torrentDBPojo.hash);
            }
            catch (Throwable throwable) {
                LOG.error("Issues with POJO deserialization -> " + string5, throwable);
            }
        }
        System.out.println("Ended up with " + arrayList.size() + " results");
        return arrayList;
    }

    public List<DeepSearchResult> deepSearch(byte[] byArray, String string) {
        SearchResultMediator searchResultMediator = null;
        this.sleep();
        int n = this.DEEP_SEARCH_ROUNDS;
        boolean bl = true;
        for (int i = n; i > 0; --i) {
            searchResultMediator = SearchMediator.getResultPanelForGUID(new GUID(byArray));
            if (searchResultMediator == null) {
                return null;
            }
            if (searchResultMediator.isStopped()) {
                return null;
            }
            this.scanAvailableResults(byArray, string, searchResultMediator, bl);
            bl = false;
            this.sleep();
        }
        if (searchResultMediator == null) {
            return null;
        }
        return null;
    }

    public void sleep() {
        try {
            Thread.sleep(this.DEEP_SEARCH_DELAY);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void scanAvailableResults(byte[] byArray, String string, SearchResultMediator searchResultMediator, boolean bl) {
        int n = 0;
        List<SearchResultDataLine> list = searchResultMediator.getAllData();
        this.sortAndStripNonTorrents(list);
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            SearchEngine searchEngine;
            WebSearchResult webSearchResult;
            SearchResultDataLine searchResultDataLine = list.get(i);
            if (!((SearchResult)searchResultDataLine.getInitializeObject()).allowDeepSearch()) continue;
            if (searchResultDataLine.getInitializeObject() instanceof SearchEngineSearchResult) {
                if (n >= this.MAXIMUM_TORRENTS_TO_SCAN) {
                    if (bl) continue;
                    return;
                }
                ++n;
                webSearchResult = searchResultDataLine.getSearchResult().getWebSearchResult();
                if (this.KNOWN_INFO_HASHES.contains(webSearchResult.getHash())) continue;
                this.KNOWN_INFO_HASHES.add(webSearchResult.getHash());
                searchEngine = searchResultDataLine.getSearchEngine();
                this.scanDotTorrent(n2++, webSearchResult, byArray, string, searchEngine);
                continue;
            }
            if (!(searchResultDataLine.getInitializeObject() instanceof YouTubePackageSearchResult) || !bl) continue;
            webSearchResult = searchResultDataLine.getSearchResult().getWebSearchResult();
            searchEngine = searchResultDataLine.getSearchEngine();
            CrawlYouTubePackage crawlYouTubePackage = new CrawlYouTubePackage(n2++, byArray, string, (YouTubeSearchResult)webSearchResult, searchEngine);
            CRAWL_YOUTUBE_LINKS_EXECUTOR.execute(crawlYouTubePackage);
        }
    }

    private void sortAndStripNonTorrents(List<SearchResultDataLine> list) {
        Collections.sort(list, TORRENT_SEED_TABLELINE_COMPARATOR);
        Iterator<SearchResultDataLine> iterator = list.iterator();
        while (iterator.hasNext()) {
            SearchResultDataLine searchResultDataLine = iterator.next();
            if (searchResultDataLine.getExtension().toLowerCase().contains("torrent") || searchResultDataLine.getExtension().toLowerCase().contains("youtube")) continue;
            iterator.remove();
        }
    }

    private void scanDotTorrent(int n, WebSearchResult webSearchResult, byte[] byArray, String string, SearchEngine searchEngine) {
        if (!this.torrentHasBeenIndexed(webSearchResult.getHash())) {
            SearchResultMediator searchResultMediator = SearchMediator.getResultPanelForGUID(new GUID(byArray));
            if (searchResultMediator != null) {
                searchResultMediator.incrementSearchCount();
            }
            DownloadTorrentTask downloadTorrentTask = new DownloadTorrentTask(n, byArray, string, webSearchResult, searchEngine);
            DOWNLOAD_TORRENTS_EXECUTOR.execute(downloadTorrentTask);
        }
    }

    private boolean torrentHasBeenIndexed(String string) {
        List<List<Object>> list = this.DB.query("SELECT indexed FROM Torrents WHERE infoHash LIKE ?", string);
        return list.size() > 0 && (Boolean)list.get(0).get(0) != false;
    }

    private void indexTorrent(WebSearchResult webSearchResult, TOTorrent tOTorrent, SearchEngine searchEngine) {
        TorrentDBPojo torrentDBPojo = new TorrentDBPojo();
        torrentDBPojo.creationTime = webSearchResult.getCreationTime();
        torrentDBPojo.fileName = webSearchResult.getFileName();
        torrentDBPojo.hash = webSearchResult.getHash();
        torrentDBPojo.searchEngineID = searchEngine.getId();
        torrentDBPojo.seeds = webSearchResult.getSeeds();
        torrentDBPojo.size = webSearchResult.getSize();
        torrentDBPojo.torrentDetailsURL = webSearchResult.getDetailsUrl();
        torrentDBPojo.torrentURI = webSearchResult.getTorrentURI();
        torrentDBPojo.vendor = webSearchResult.getSource();
        TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
        TorrentFileDBPojo[] torrentFileDBPojoArray = new TorrentFileDBPojo[tOTorrentFileArray.length];
        for (int i = 0; i < tOTorrentFileArray.length; ++i) {
            TOTorrentFile tOTorrentFile = tOTorrentFileArray[i];
            TorrentFileDBPojo torrentFileDBPojo = new TorrentFileDBPojo();
            torrentFileDBPojo.relativePath = tOTorrentFile.getRelativePath();
            torrentFileDBPojo.size = tOTorrentFile.getLength();
            torrentFileDBPojoArray[i] = torrentFileDBPojo;
        }
        this.INDEX_TORRENT_QUEUE.offer(new IndexTorrentElement(torrentDBPojo, torrentFileDBPojoArray));
        INDEX_TORRENTS_EXECUTOR.execute(new IndexTorrentTask());
    }

    public void shutdown() {
        this.DB.close();
    }

    public long getTotalTorrents() {
        List<List<Object>> list = this.DB.query("SELECT COUNT(*) FROM Torrents", new Object[0]);
        return list.size() > 0 ? (Long)list.get(0).get(0) : 0L;
    }

    public long getTotalFiles() {
        List<List<Object>> list = this.DB.query("SELECT COUNT(*) FROM Files", new Object[0]);
        return list.size() > 0 ? (Long)list.get(0).get(0) : 0L;
    }

    public void resetDB() {
        this.DB.reset();
        this.KNOWN_INFO_HASHES.clear();
    }

    static {
        TORRENT_SEED_TABLELINE_COMPARATOR = new Comparator<SearchResultDataLine>(){

            @Override
            public int compare(SearchResultDataLine searchResultDataLine, SearchResultDataLine searchResultDataLine2) {
                return searchResultDataLine2.getSeeds() - searchResultDataLine.getSeeds();
            }
        };
        IGNORABLE_KEYWORDS = new HashSet();
        IGNORABLE_KEYWORDS.addAll(Arrays.asList("me", "you", "he", "she", "they", "them", "we", "us", "my", "your", "yours", "his", "hers", "theirs", "ours", "the", "of", "in", "on", "out", "to", "at", "as", "and", "by", "not", "is", "are", "am", "was", "were", "will", "be", "for", "el", "la", "es", "de", "los", "las", "en"));
    }

    private static class IndexTorrentElement {
        public final TorrentDBPojo torrent;
        public final TorrentFileDBPojo[] files;

        public IndexTorrentElement(TorrentDBPojo torrentDBPojo, TorrentFileDBPojo[] torrentFileDBPojoArray) {
            this.torrent = torrentDBPojo;
            this.files = torrentFileDBPojoArray;
        }
    }

    private class IndexTorrentTask
    implements Runnable {
        private IndexTorrentTask() {
        }

        @Override
        public void run() {
            try {
                int n;
                IndexTorrentElement indexTorrentElement;
                ArrayList<IndexTorrentElement> arrayList = new ArrayList<IndexTorrentElement>();
                for (n = 0; n < 1000 && (indexTorrentElement = (IndexTorrentElement)LocalSearchEngine.this.INDEX_TORRENT_QUEUE.poll()) != null; n += indexTorrentElement.files.length) {
                    arrayList.add(indexTorrentElement);
                }
                this.indexElements(arrayList);
                if (n > 0) {
                    Thread.sleep(1000L);
                }
            }
            catch (Throwable throwable) {
                LOG.error("General error in torrent index task", throwable);
            }
        }

        private void indexElements(ArrayList<IndexTorrentElement> arrayList) {
            FullTextLucene2.enableIndexing("FILES", false);
            for (int i = 0; i < arrayList.size(); ++i) {
                this.indexElement(arrayList.get(i), i == arrayList.size() - 1);
            }
        }

        private void indexElement(IndexTorrentElement indexTorrentElement, boolean bl) {
            TorrentDBPojo torrentDBPojo = indexTorrentElement.torrent;
            TorrentFileDBPojo[] torrentFileDBPojoArray = indexTorrentElement.files;
            String string = LocalSearchEngine.this.JSON_ENGINE.toJson(torrentDBPojo);
            int n = LocalSearchEngine.this.DB.insert("INSERT INTO Torrents (infoHash, timestamp, torrentName, seeds, indexed, json) VALUES (?, ?, LEFT(?, 10000), ?, ?, ?)", torrentDBPojo.hash, System.currentTimeMillis(), torrentDBPojo.fileName.toLowerCase(), torrentDBPojo.seeds, false, string);
            for (int i = 0; i < torrentFileDBPojoArray.length; ++i) {
                if (bl && i == indexTorrentElement.files.length - 1) {
                    FullTextLucene2.enableIndexing("FILES", true);
                }
                TorrentFileDBPojo torrentFileDBPojo = torrentFileDBPojoArray[i];
                String string2 = LocalSearchEngine.this.JSON_ENGINE.toJson(torrentFileDBPojo);
                String string3 = LocalSearchEngine.stringSanitize(torrentDBPojo.fileName + " " + torrentFileDBPojo.relativePath).toLowerCase();
                LocalSearchEngine.this.DB.insert("INSERT INTO Files (torrentId, fileName, json, keywords) VALUES (?, LEFT(?, 10000), ?, ?)", n, torrentFileDBPojo.relativePath, string2, string3);
            }
            LocalSearchEngine.this.DB.update("UPDATE Torrents SET indexed=? WHERE torrentId=?", true, n);
        }
    }

    private class CrawlYouTubePackage
    implements DeepTask {
        private final int order;
        private final byte[] guid;
        private final String query;
        private final SearchEngine searchEngine;
        private final YouTubeSearchResult webSearchResult;

        public CrawlYouTubePackage(int n, byte[] byArray, String string, YouTubeSearchResult youTubeSearchResult, SearchEngine searchEngine) {
            this.order = n;
            this.guid = byArray;
            this.query = string;
            this.searchEngine = searchEngine;
            this.webSearchResult = youTubeSearchResult;
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public int compareTo(DeepTask deepTask) {
            return Integer.valueOf(this.getOrder()).compareTo(deepTask.getOrder());
        }

        @Override
        public void run() {
            try {
                SearchResultMediator searchResultMediator = SearchMediator.getResultPanelForGUID(new GUID(this.guid));
                if (searchResultMediator == null || searchResultMediator.isStopped()) {
                    return;
                }
                LinkCollector linkCollector = LinkCollector.getInstance();
                LinkCrawler linkCrawler = new LinkCrawler();
                linkCrawler.setFilter(LinkFilterController.getInstance());
                linkCrawler.crawl(this.readVideoUrl(this.webSearchResult.getYouTubeEntry()));
                linkCrawler.waitForCrawling();
                ArrayList<FilePackage> arrayList = new ArrayList<FilePackage>();
                for (CrawledLink crawledLink : linkCrawler.getCrawledLinks()) {
                    CrawledPackage crawledPackage = PackageInfo.createCrawledPackage(crawledLink);
                    crawledPackage.setControlledBy(linkCollector);
                    crawledLink.setParentNode(crawledPackage);
                    ArrayList<CrawledLink> arrayList2 = new ArrayList<CrawledLink>();
                    arrayList2.add(crawledLink);
                    arrayList.add(this.createFilePackage(crawledPackage, arrayList2));
                }
                this.matchResults(arrayList);
            }
            catch (Throwable throwable) {
                LOG.error("Error crawling youtube: " + this.webSearchResult.getDisplayName(), throwable);
            }
        }

        private String readVideoUrl(YouTubeEntry youTubeEntry) {
            String string = null;
            for (YouTubeEntryLink youTubeEntryLink : youTubeEntry.link) {
                if (!youTubeEntryLink.rel.equals("alternate")) continue;
                string = youTubeEntryLink.href;
            }
            string = string.replace("https://", "http://").replace("&feature=youtube_gdata", "");
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FilePackage createFilePackage(CrawledPackage crawledPackage, ArrayList<CrawledLink> arrayList) {
            FilePackage filePackage = FilePackage.getInstance();
            filePackage.setName(crawledPackage.getName());
            filePackage.setDownloadDirectory(crawledPackage.getDownloadFolder());
            filePackage.setCreated(crawledPackage.getCreated());
            filePackage.setExpanded(crawledPackage.isExpanded());
            filePackage.setComment(crawledPackage.getComment());
            CrawledPackage crawledPackage2 = crawledPackage;
            synchronized (crawledPackage2) {
                ArrayList<DownloadLink> arrayList2 = new ArrayList<DownloadLink>(crawledPackage.getChildren().size());
                List<CrawledLink> list = crawledPackage.getChildren();
                if (arrayList != null && arrayList.size() > 0) {
                    list = new ArrayList<CrawledLink>(arrayList);
                }
                for (CrawledLink crawledLink : list) {
                    DownloadLink downloadLink = crawledLink.getDownloadLink();
                    if (downloadLink == null) continue;
                    if (crawledLink.isNameSet()) {
                        downloadLink.forceFileName(crawledLink.getName());
                    }
                    downloadLink.setNodeChangeListener(null);
                    downloadLink.setCreated(crawledLink.getCreated());
                    arrayList2.add(downloadLink);
                    downloadLink.setParentNode(filePackage);
                }
                filePackage.getChildren().addAll(arrayList2);
            }
            return filePackage;
        }

        private void matchResults(List<FilePackage> list) {
            if (!this.searchEngine.isEnabled()) {
                return;
            }
            final SearchResultMediator searchResultMediator = SearchMediator.getResultPanelForGUID(new GUID(this.guid));
            if (searchResultMediator == null || searchResultMediator.isStopped()) {
                return;
            }
            searchResultMediator.decrementSearchCount();
            SearchFilter searchFilter = SearchMediator.getSearchFilterFactory().createFilter();
            for (FilePackage filePackage : list) {
                try {
                    final YouTubePackageItemSearchResult youTubePackageItemSearchResult = new YouTubePackageItemSearchResult(this.webSearchResult, filePackage, this.searchEngine, this.query);
                    if (filePackage.getChildren().get(0).getFileOutput().endsWith(".mp3") || !searchFilter.allow(youTubePackageItemSearchResult)) continue;
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SearchMediator.getSearchResultDisplayer().addQueryResult(CrawlYouTubePackage.this.guid, youTubePackageItemSearchResult, searchResultMediator);
                        }
                    });
                }
                catch (Throwable throwable) {
                    LOG.error("Error analysing youtube package", throwable);
                }
            }
        }
    }

    private class DownloadTorrentTask
    implements DeepTask {
        private final int order;
        private final byte[] guid;
        private final String query;
        private final SearchEngine searchEngine;
        private final WebSearchResult webSearchResult;

        public DownloadTorrentTask(int n, byte[] byArray, String string, WebSearchResult webSearchResult, SearchEngine searchEngine) {
            this.order = n;
            this.guid = byArray;
            this.query = string;
            this.searchEngine = searchEngine;
            this.webSearchResult = webSearchResult;
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public int compareTo(DeepTask deepTask) {
            return Integer.valueOf(this.getOrder()).compareTo(deepTask.getOrder());
        }

        @Override
        public void run() {
            SearchResultMediator searchResultMediator = SearchMediator.getResultPanelForGUID(new GUID(this.guid));
            if (searchResultMediator == null || searchResultMediator.isStopped()) {
                return;
            }
            String string = SearchSettings.SMART_SEARCH_DATABASE_FOLDER.getValue().getAbsolutePath();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            TorrentDownloaderFactory.create(new LocalSearchTorrentDownloaderListener(this.guid, this.query, this.webSearchResult, this.searchEngine, countDownLatch), this.webSearchResult.getTorrentURI(), this.webSearchResult.getDetailsUrl(), string).start();
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                LOG.error("Error during await in DownloadTorrentTask", interruptedException);
            }
        }
    }

    private static interface DeepTask
    extends Runnable,
    Comparable<DeepTask> {
        public int getOrder();
    }

    private class LocalSearchTorrentDownloaderListener
    implements TorrentDownloaderCallBackInterface {
        private final AtomicBoolean finished = new AtomicBoolean(false);
        private final byte[] guid;
        private final String query;
        private final Set<String> tokens;
        private final SearchEngine searchEngine;
        private final WebSearchResult webSearchResult;
        private final CountDownLatch finishSignal;

        public LocalSearchTorrentDownloaderListener(byte[] byArray, String string, WebSearchResult webSearchResult, SearchEngine searchEngine, CountDownLatch countDownLatch) {
            this.guid = byArray;
            this.query = string;
            this.tokens = new HashSet<String>(Arrays.asList(string.toLowerCase().split(" ")));
            this.searchEngine = searchEngine;
            this.webSearchResult = webSearchResult;
            this.finishSignal = countDownLatch;
        }

        @Override
        public void TorrentDownloaderEvent(int n, TorrentDownloader torrentDownloader) {
            Object object;
            if (n == 3 && this.finished.compareAndSet(false, true)) {
                try {
                    object = torrentDownloader.getFile();
                    TOTorrent tOTorrent = TorrentUtils.readFromFile((File)object, false);
                    this.matchResults(tOTorrent);
                    LocalSearchEngine.this.indexTorrent(this.webSearchResult, tOTorrent, this.searchEngine);
                    ((File)object).delete();
                }
                catch (Throwable throwable) {
                    LOG.error("Error during torrent indexing", throwable);
                }
                this.finishSignal.countDown();
            }
            switch (n) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    object = SearchMediator.getResultPanelForGUID(new GUID(this.guid));
                    if (object != null) {
                        ((SearchResultMediator)object).decrementSearchCount();
                    }
                    this.finishSignal.countDown();
                }
            }
        }

        private void matchResults(TOTorrent tOTorrent) {
            if (!this.searchEngine.isEnabled()) {
                return;
            }
            final SearchResultMediator searchResultMediator = SearchMediator.getResultPanelForGUID(new GUID(this.guid));
            if (searchResultMediator == null || searchResultMediator.isStopped()) {
                return;
            }
            searchResultMediator.decrementSearchCount();
            SearchFilter searchFilter = SearchMediator.getSearchFilterFactory().createFilter();
            TOTorrentFile[] tOTorrentFileArray = tOTorrent.getFiles();
            for (int i = 0; i < tOTorrentFileArray.length; ++i) {
                try {
                    final DeepSearchResult deepSearchResult = new DeepSearchResult(tOTorrentFileArray[i], this.webSearchResult, this.searchEngine, this.query);
                    if (!searchFilter.allow(deepSearchResult)) continue;
                    boolean bl = true;
                    String string = LocalSearchEngine.stringSanitize(deepSearchResult.getFileName() + " " + tOTorrentFileArray[i].getRelativePath()).toLowerCase();
                    for (String string2 : this.tokens) {
                        if (string.contains(string2)) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SearchMediator.getSearchResultDisplayer().addQueryResult(LocalSearchTorrentDownloaderListener.this.guid, deepSearchResult, searchResultMediator);
                        }
                    });
                    continue;
                }
                catch (Throwable throwable) {
                    LOG.error("Error analysing torrent file", throwable);
                }
            }
        }
    }
}

