/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MagnetOptions;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;

public class MagnetClipboardListener
extends WindowAdapter {
    private static final Log LOG = LogFactory.getLog(MagnetClipboardListener.class);
    private static final MagnetClipboardListener instance = new MagnetClipboardListener();
    private static final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final StringSelection empty = new StringSelection("");
    private volatile String copiedText;
    private final ExecutorService clipboardParser = ExecutorsHelper.newProcessingQueue("clipboard parser");
    private Runnable parser = new Runnable(){

        @Override
        public void run() {
            MagnetClipboardListener.this.parseAndLaunch();
        }
    };

    private void parseAndLaunch() {
        String string = MagnetClipboardListener.extractStringContentFromClipboard(this);
        if (string == null) {
            return;
        }
        String string2 = this.copiedText;
        if (string2 != null && string2.equals(string)) {
            return;
        }
        MagnetOptions[] magnetOptionsArray = MagnetOptions.parseMagnets(string);
        if (magnetOptionsArray.length == 0) {
            return;
        }
        LOG.info("clipboard contains " + string);
        this.purgeClipboard();
        MagnetClipboardListener.handleMagnets(magnetOptionsArray, true);
    }

    private MagnetClipboardListener() {
    }

    public static MagnetClipboardListener getInstance() {
        return instance;
    }

    public void setCopiedText(String string) {
        this.copiedText = string;
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.clipboardParser.execute(this.parser);
    }

    private void purgeClipboard() {
        try {
            CLIPBOARD.setContents(this.empty, this.empty);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void handleMagnets(final MagnetOptions[] magnetOptionsArray, final boolean bl) {
        final MagnetOptions[] magnetOptionsArray2 = MagnetClipboardListener.extractDownloadableMagnets(magnetOptionsArray);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!bl || magnetOptionsArray2.length > 0) {
                    // empty if block
                }
                boolean bl2 = false;
                for (int i = 0; i < magnetOptionsArray.length; ++i) {
                    String string;
                    SearchInformation searchInformation;
                    if (magnetOptionsArray[i].isDownloadable() || !magnetOptionsArray[i].isKeywordTopicOnly() || bl2 || SearchMediator.validateInfo(searchInformation = SearchInformation.createKeywordSearch(string = QueryUtils.createQueryString(magnetOptionsArray[i].getKeywordTopic()), null, MediaType.getAnyTypeMediaType())) != 0) continue;
                    bl2 = true;
                    SearchMediator.triggerSearch(searchInformation);
                }
                GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
            }
        };
        GUIMediator.safeInvokeLater(runnable);
    }

    public static String extractStringContentFromClipboard(Object object) {
        Transferable transferable = null;
        try {
            transferable = CLIPBOARD.getContents(object);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        if (transferable == null) {
            return null;
        }
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return null;
        }
        String string = null;
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (IOException iOException) {
            LOG.info("problem occured while trying to parse clipboard, do nothing", iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            LOG.error("UnsupportedFlavor??", unsupportedFlavorException);
        }
        return string;
    }

    public static String getMagnetOrTorrentURLFromClipboard() {
        try {
            String string = MagnetClipboardListener.extractStringContentFromClipboard(null);
            if (string == null) {
                return "";
            }
            if (string.contains("\n")) {
                string = string.split("\n")[0].trim();
            }
            if (string.startsWith("magnet:?xt=urn:btih:") || string.matches("^http.*\\.torrent$") || string.matches(".*youtube.com.*") || string.matches(".*soundcloud.com.*")) {
                return string;
            }
        }
        catch (Throwable throwable) {
            LOG.error("Error processing clipboard text", throwable);
        }
        return null;
    }

    private static MagnetOptions[] extractDownloadableMagnets(MagnetOptions[] magnetOptionsArray) {
        ArrayList<MagnetOptions> arrayList = new ArrayList<MagnetOptions>(magnetOptionsArray.length);
        for (int i = 0; i < magnetOptionsArray.length; ++i) {
            MagnetOptions magnetOptions = magnetOptionsArray[i];
            if (magnetOptions.isKeywordTopicOnly()) continue;
            arrayList.add(magnetOptionsArray[i]);
        }
        if (arrayList.size() == magnetOptionsArray.length) {
            return magnetOptionsArray;
        }
        return arrayList.toArray(new MagnetOptions[0]);
    }
}

