/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.filters.TableLineFilter;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.settings.SearchSettings;

public class MediaTypeFilter
implements TableLineFilter<SearchResultDataLine> {
    private final boolean allowAll = this.isAllSelected();

    @Override
    public boolean allow(SearchResultDataLine searchResultDataLine) {
        try {
            if (searchResultDataLine.getExtension().equals("youtube")) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.allowAll) {
            return true;
        }
        NamedMediaType namedMediaType = searchResultDataLine.getNamedMediaType();
        if (namedMediaType != null) {
            return SearchSettings.LAST_MEDIA_TYPES_USED.contains(namedMediaType.getMediaType().getMimeType());
        }
        return false;
    }

    private boolean isAllSelected() {
        boolean bl = true;
        bl &= SearchSettings.LAST_MEDIA_TYPES_USED.contains(MediaType.getAudioMediaType().getMimeType());
        bl &= SearchSettings.LAST_MEDIA_TYPES_USED.contains(MediaType.getVideoMediaType().getMimeType());
        bl &= SearchSettings.LAST_MEDIA_TYPES_USED.contains(MediaType.getImageMediaType().getMimeType());
        bl &= SearchSettings.LAST_MEDIA_TYPES_USED.contains(MediaType.getDocumentMediaType().getMimeType());
        bl &= SearchSettings.LAST_MEDIA_TYPES_USED.contains(MediaType.getProgramMediaType().getMimeType());
        return bl &= SearchSettings.LAST_MEDIA_TYPES_USED.contains(MediaType.getTorrentMediaType().getMimeType());
    }
}

