/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.LimeXMLSchema;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.XMLUtils;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class NamedMediaType
implements IconAndNameHolder,
Comparable<NamedMediaType> {
    private static final String IMAGE_RESOURCE_PATH = "org/limewire/xml/image/";
    private static final Map<String, NamedMediaType> CACHED_TYPES = new HashMap<String, NamedMediaType>();
    private final MediaType _mediaType;
    private final String _name;
    private final Icon _icon;
    private final LimeXMLSchema _schema;

    public NamedMediaType(MediaType mediaType, LimeXMLSchema limeXMLSchema) {
        if (mediaType == null) {
            throw new NullPointerException("Null media type.");
        }
        this._mediaType = mediaType;
        this._schema = limeXMLSchema;
        this._name = NamedMediaType.constructName(this._mediaType, this._schema);
        this._icon = this.getIcon(this._mediaType, this._schema);
    }

    @Override
    public int compareTo(NamedMediaType namedMediaType) {
        return this._name.compareTo(namedMediaType._name);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Icon getIcon() {
        return this._icon;
    }

    public String toString() {
        return this._name;
    }

    public MediaType getMediaType() {
        return this._mediaType;
    }

    public LimeXMLSchema getSchema() {
        return this._schema;
    }

    public static NamedMediaType getFromDescription(String string) {
        NamedMediaType namedMediaType = CACHED_TYPES.get(string);
        if (namedMediaType != null) {
            return namedMediaType;
        }
        MediaType mediaType = !MediaType.isDefaultType(string) ? new MediaType(string) : MediaType.getMediaTypeForSchema(string);
        return NamedMediaType.getFromMediaType(mediaType);
    }

    public static NamedMediaType getFromExtension(String string) {
        MediaType mediaType = MediaType.getMediaTypeForExtension(string);
        if (mediaType == null) {
            return null;
        }
        String string2 = mediaType.getMimeType();
        return NamedMediaType.getFromDescription(string2);
    }

    public static List<NamedMediaType> getAllNamedMediaTypes() {
        LinkedList<NamedMediaType> linkedList = new LinkedList<NamedMediaType>();
        MediaType[] mediaTypeArray = MediaType.getDefaultMediaTypes();
        for (int i = 0; i < mediaTypeArray.length; ++i) {
            if (NamedMediaType.containsMediaType(linkedList, mediaTypeArray[i])) continue;
            linkedList.add(NamedMediaType.getFromMediaType(mediaTypeArray[i]));
        }
        return linkedList;
    }

    public static NamedMediaType getFromMediaType(MediaType mediaType) {
        String string = mediaType.getMimeType();
        NamedMediaType namedMediaType = CACHED_TYPES.get(string);
        if (namedMediaType != null) {
            return namedMediaType;
        }
        namedMediaType = new NamedMediaType(mediaType, null);
        CACHED_TYPES.put(string, namedMediaType);
        return namedMediaType;
    }

    private static boolean containsMediaType(List<? extends NamedMediaType> list, MediaType mediaType) {
        for (NamedMediaType namedMediaType : list) {
            if (!namedMediaType.getMediaType().equals(mediaType)) continue;
            return true;
        }
        return false;
    }

    private Icon getIcon(MediaType mediaType, LimeXMLSchema limeXMLSchema) {
        ImageIcon imageIcon;
        if (mediaType == MediaType.getAnyTypeMediaType()) {
            imageIcon = GUIMediator.getThemeImage("lime");
        } else {
            String string = IMAGE_RESOURCE_PATH + mediaType.getMimeType();
            imageIcon = GUIMediator.getImageFromResourcePath(string);
            if (imageIcon == null) {
                return new GUIUtils.EmptyIcon(this.getName(), 16, 16);
            }
        }
        imageIcon.setDescription(this.getName());
        return imageIcon;
    }

    private static String constructName(MediaType mediaType, LimeXMLSchema limeXMLSchema) {
        String string = null;
        if (mediaType.isDefault()) {
            String string2 = mediaType.getDescriptionKey();
            try {
                if (string2 != null) {
                    string = I18n.tr(string2);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (string == null) {
                string = mediaType.getMimeType();
                string = string.substring(0, 1).toUpperCase(Locale.US) + string.substring(1);
            }
        } else {
            string = XMLUtils.getTitleForSchema(limeXMLSchema);
        }
        return string;
    }
}

