/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.SpamFilter;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.settings.SearchSettings;
import java.util.HashMap;
import java.util.Map;

class ResultPanelModel
extends BasicDataLineModel<SearchResultDataLine, SearchResult> {
    private static final long serialVersionUID = -2382156313320196261L;
    protected final SearchTableColumns COLUMNS = new SearchTableColumns();
    private final Map<String, Integer> _indexes = new HashMap<String, Integer>();
    private int _numSources;
    private int _numResults;

    ResultPanelModel() {
        super(SearchResultDataLine.class);
    }

    SearchTableColumns getColumns() {
        return this.COLUMNS;
    }

    @Override
    public SearchResultDataLine createDataLine() {
        return new SearchResultDataLine(this.COLUMNS);
    }

    @Override
    public LimeTableColumn getTableColumn(int n) {
        return this.COLUMNS.getColumn(n);
    }

    @Override
    public int compare(SearchResultDataLine searchResultDataLine, SearchResultDataLine searchResultDataLine2) {
        int n = this.compareSpam(searchResultDataLine, searchResultDataLine2);
        if (n != 0) {
            return n;
        }
        if (this._activeColumn == 1) {
            return AbstractTableMediator.compare(searchResultDataLine.getExtension(), searchResultDataLine2.getExtension()) * this._ascending;
        }
        if (!this.isSorted() || this._activeColumn != 0) {
            return super.compare(searchResultDataLine, searchResultDataLine2);
        }
        return this.compareCount(searchResultDataLine, searchResultDataLine2, false);
    }

    @Override
    public void remove(int n) {
        SearchResultDataLine searchResultDataLine = (SearchResultDataLine)this.get(n);
        String string = this.getHash(n);
        if (string != null) {
            this._indexes.remove(string);
        }
        super.remove(n);
        this._numSources -= searchResultDataLine.getSeeds();
        --this._numResults;
        this.remapIndexes(n);
    }

    @Override
    public int add(SearchResult searchResult) {
        return this.add(searchResult, this.getRowCount());
    }

    @Override
    public int add(SearchResultDataLine searchResultDataLine) {
        return super.add(searchResultDataLine);
    }

    @Override
    public Object refresh() {
        this.fireTableRowsUpdated(0, this.getRowCount());
        return null;
    }

    public void slowRefresh() {
        super.refresh();
    }

    @Override
    public int add(SearchResultDataLine searchResultDataLine, int n) {
        this._numSources += searchResultDataLine.getSeeds();
        ++this._numResults;
        String string = searchResultDataLine.getHash();
        if (string != null) {
            this._indexes.put(string, new Integer(n));
        }
        int n2 = super.add(searchResultDataLine, n);
        this.remapIndexes(n2 + 1);
        return n2;
    }

    @Override
    public int getRow(SearchResultDataLine searchResultDataLine) {
        String string = searchResultDataLine.getHash();
        if (string != null) {
            return this.fastMatch(string);
        }
        return super.getRow(searchResultDataLine);
    }

    int getTotalSources() {
        return this._numSources;
    }

    @Override
    protected void doResort() {
        super.doResort();
        this._indexes.clear();
        this.remapIndexes(0);
    }

    @Override
    public void clear() {
        this.simpleClear();
    }

    @Override
    protected void cleanup() {
    }

    protected void simpleClear() {
        this._numSources = 0;
        this._numResults = 0;
        this._indexes.clear();
        super.clear();
    }

    private void remapIndexes(int n) {
        this.remapIndexes(n, this.getRowCount());
    }

    private void remapIndexes(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            String string = this.getHash(i);
            if (string == null) continue;
            this._indexes.put(string, new Integer(i));
        }
    }

    private String getHash(int n) {
        if (n >= this.getRowCount()) {
            return null;
        }
        return ((SearchResultDataLine)this.get(n)).getHash();
    }

    private int compareSpam(SearchResultDataLine searchResultDataLine, SearchResultDataLine searchResultDataLine2) {
        if (SearchSettings.moveJunkToBottom()) {
            if (SpamFilter.isAboveSpamThreshold(searchResultDataLine)) {
                if (!SpamFilter.isAboveSpamThreshold(searchResultDataLine2)) {
                    return 1;
                }
            } else if (SpamFilter.isAboveSpamThreshold(searchResultDataLine2)) {
                return -1;
            }
        }
        return 0;
    }

    private int compareCount(SearchResultDataLine searchResultDataLine, SearchResultDataLine searchResultDataLine2, boolean bl) {
        int n;
        if (bl && (n = this.compareSpam(searchResultDataLine, searchResultDataLine2)) != 0) {
            return n;
        }
        n = searchResultDataLine.getSeeds() + (searchResultDataLine.getDisplayName().indexOf("(AAC-High Quality)") == 0 ? 1000 : 0);
        int n2 = searchResultDataLine2.getSeeds() + (searchResultDataLine2.getDisplayName().indexOf("(AAC-High Quality)") == 0 ? 1000 : 0);
        int n3 = searchResultDataLine.getSearchEngine().getId();
        int n4 = searchResultDataLine2.getSearchEngine().getId();
        if (n3 == 9) {
            n += 1000;
        }
        if (n4 == 9) {
            n2 += 1000;
        }
        if (n3 == 10) {
            n += 200;
        }
        if (n4 == 10) {
            n2 += 200;
        }
        return (n - n2) * this._ascending;
    }

    private int fastMatch(String string) {
        Integer n = this._indexes.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public int getTotalResults() {
        return this._numResults;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 2 || n2 == 4;
    }
}

