/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIUtils;

class ResultSpeed
implements Comparable<ResultSpeed> {
    private int speed;
    private String description;
    private boolean isMeasured;

    public ResultSpeed(int n, boolean bl) {
        this.speed = n;
        this.isMeasured = bl;
        this.description = GUIUtils.speed2name(n);
    }

    public int intValue() {
        return this.speed;
    }

    public String stringValue() {
        return this.description;
    }

    public boolean isMeasured() {
        return this.isMeasured;
    }

    public int isFaster(ResultSpeed resultSpeed) {
        return this.speed - resultSpeed.speed;
    }

    public boolean equals(Object object) {
        if (object instanceof ResultSpeed) {
            ResultSpeed resultSpeed = (ResultSpeed)object;
            return resultSpeed.speed == this.speed;
        }
        return false;
    }

    @Override
    public int compareTo(ResultSpeed resultSpeed) {
        int n = this.speed - resultSpeed.speed;
        if (n == 0) {
            return 0;
        }
        int n2 = this.description.compareTo(resultSpeed.description);
        if (n2 == 0) {
            return 0;
        }
        return n;
    }

    public boolean isSameSpeed(ResultSpeed resultSpeed) {
        return this.description.equals(resultSpeed.description);
    }

    public String toString() {
        return this.stringValue();
    }
}

